/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;

public interface HussarCache
extends Cache {
    public void put(Object var1, Object var2, Duration var3);

    public void put(Object var1, Object var2, long var3);

    default public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Cache.ValueWrapper existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    default public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, Duration timeout) {
        Cache.ValueWrapper existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value, timeout);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    default public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, long seconds) {
        Duration timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        Cache.ValueWrapper existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value, timeoutDuration);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    public boolean containKey(Object var1);

    public List<String> getKeys(String var1);

    public List<String> scanKeys(String var1);

    public void evictKeys(String var1);

    public Map<String, Object> getKeysAndValues(String var1);

    public Long getKeyExpireTime(Object var1);
}

