/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.ehcache;

import com.jxdinfo.hussar.support.cache.support.SpringAbstractTransactionSupportingCacheManager;
import com.jxdinfo.hussar.support.cache.support.ehcache.HussarEhcacheCache;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.ehcache.EhCacheManagerUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpringEhCacheCacheManager
extends SpringAbstractTransactionSupportingCacheManager {
    @Nullable
    private CacheManager cacheManager;

    public SpringEhCacheCacheManager() {
    }

    public SpringEhCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(@Nullable CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Nullable
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getCacheManager() == null) {
            this.setCacheManager(EhCacheManagerUtils.buildCacheManager());
        }
        super.afterPropertiesSet();
    }

    protected Collection<Cache> loadCaches() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.state((cacheManager != null ? 1 : 0) != 0, (String)"No CacheManager set");
        Status status = cacheManager.getStatus();
        if (!Status.STATUS_ALIVE.equals(status)) {
            throw new IllegalStateException("An 'alive' EhCache CacheManager is required - current cache is " + status.toString());
        }
        String[] names = this.getCacheManager().getCacheNames();
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(names.length);
        for (String name : names) {
            caches.add(new HussarEhcacheCache(new EhCacheCache(this.getCacheManager().getEhcache(name))));
        }
        return caches;
    }

    @Override
    protected Cache getMissingCache(String name) {
        CacheManager cacheManager = this.getCacheManager();
        Assert.state((cacheManager != null ? 1 : 0) != 0, (String)"No CacheManager set");
        Ehcache ehcache = cacheManager.getEhcache(name);
        if (ehcache == null) {
            ehcache = this.cacheManager.addCacheIfAbsent(name);
        }
        return new HussarEhcacheCache(new EhCacheCache(ehcache));
    }
}

