/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HussarSpringRedisCacheWriter
implements RedisCacheWriter {
    private final RedisConnectionFactory connectionFactory;
    private final Duration sleepTime;

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, Duration.ZERO);
    }

    public HussarSpringRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)sleepTime, (String)"SleepTime must not be null!");
        this.connectionFactory = connectionFactory;
        this.sleepTime = sleepTime;
    }

    public void put(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (HussarSpringRedisCacheWriter.shouldExpireWithin(ttl)) {
                connection.set(key, value, Expiration.from((long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.upsert());
            } else {
                connection.set(key, value);
            }
            return "OK";
        });
    }

    public byte[] get(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.execute(name, connection -> connection.get(key));
    }

    public byte[] putIfAbsent(String name, byte[] key, byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.execute(name, connection -> {
            if (this.isLockingCacheWriter()) {
                this.doLock(name, (RedisConnection)connection);
            }
            try {
                boolean put = HussarSpringRedisCacheWriter.shouldExpireWithin(ttl) ? connection.set(key, value, Expiration.from((Duration)ttl), RedisStringCommands.SetOption.ifAbsent()).booleanValue() : connection.setNX(key, value).booleanValue();
                if (put) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = connection.get(key);
                return byArray;
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
        });
    }

    public void remove(String name, byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> connection.del((byte[][])new byte[][]{key}));
    }

    public void clean(String name, byte[] pattern) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        this.execute(name, connection -> {
            boolean wasLocked = false;
            try {
                byte[][] keys;
                if (this.isLockingCacheWriter()) {
                    this.doLock(name, (RedisConnection)connection);
                    wasLocked = true;
                }
                if ((keys = (byte[][])Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).toArray((T[])new byte[0][])).length > 0) {
                    connection.del(keys);
                }
            }
            finally {
                if (wasLocked && this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
            return "OK";
        });
    }

    void lock(String name) {
        this.execute(name, connection -> this.doLock(name, (RedisConnection)connection));
    }

    void unlock(String name) {
        this.executeLockFree(connection -> this.doUnlock(name, (RedisConnection)connection));
    }

    private Boolean doLock(String name, RedisConnection connection) {
        return connection.setNX(HussarSpringRedisCacheWriter.createCacheLockKey(name), new byte[0]);
    }

    private Long doUnlock(String name, RedisConnection connection) {
        return connection.del((byte[][])new byte[][]{HussarSpringRedisCacheWriter.createCacheLockKey(name)});
    }

    boolean doCheckLock(String name, RedisConnection connection) {
        return connection.exists(HussarSpringRedisCacheWriter.createCacheLockKey(name));
    }

    private boolean isLockingCacheWriter() {
        return !this.sleepTime.isZero() && !this.sleepTime.isNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String name, Function<RedisConnection, T> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.checkAndPotentiallyWaitUntilUnlocked(name, connection);
            T t = callback.apply(connection);
            return t;
        }
    }

    public void executeLockFree(Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            callback.accept(connection);
        }
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name, RedisConnection connection) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        try {
            while (this.doCheckLock(name, connection)) {
                Thread.sleep(this.sleepTime.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
    }

    private static boolean shouldExpireWithin(@Nullable Duration ttl) {
        return ttl != null && !ttl.isZero() && !ttl.isNegative();
    }

    private static byte[] createCacheLockKey(String name) {
        return (name + "~lock").getBytes(StandardCharsets.UTF_8);
    }
}

