/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.jxdinfo.hussar.support.cache.support.HussarAbstractCacheManager;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisCache;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisCacheWriter;
import java.util.Collection;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class HussarRedisManager
extends HussarAbstractCacheManager {
    private RedisCacheManager cacheManager;
    private final RedisConnectionFactory redisConnectionFactory;
    private final HussarRedisCacheWriter redisCacheWriter;

    public HussarRedisManager(RedisCacheManager cacheManager, RedisConnectionFactory redisConnectionFactory, HussarRedisCacheWriter redisCacheWriter) {
        this.cacheManager = cacheManager;
        this.redisConnectionFactory = redisConnectionFactory;
        this.redisCacheWriter = redisCacheWriter;
    }

    @Override
    public HussarCache cover(Cache cache) {
        return new HussarRedisCache((RedisCache)cache, this.redisCacheWriter, this.redisConnectionFactory);
    }

    @Override
    public HussarCache getMissingCache(String cacheName) {
        return this.cover(this.cacheManager.getCache(cacheName));
    }

    @Override
    public Collection<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }
}

