/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.util;

import com.jxdinfo.hussar.support.cache.util.AbstractHussarCacheOperator;
import java.time.Duration;
import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultCacheUtil
extends AbstractHussarCacheOperator {
    private static final String DEFAULT_CACHE_NAME = "default_cache_name";

    public static void put(Object key, Object value) {
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).put(key, value, Duration.ZERO);
    }

    public static void put(Object key, Object value, long seconds) {
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).put(key, value, seconds);
    }

    public static <T> T putIfAbsent(Object key, @Nullable T value) {
        Cache.ValueWrapper valueWrapper = DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).putIfAbsent(key, value);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T putIfAbsent(Object key, @Nullable T value, long seconds) {
        Cache.ValueWrapper valueWrapper = DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).putIfAbsent(key, value, seconds);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T get(Object key, @Nullable Class<T> type) {
        Object t = null;
        try {
            t = DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).get(key, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> T get(Object key) {
        Cache.ValueWrapper valueWrapper = DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).get(key);
        if (valueWrapper == null) {
            return null;
        }
        return (T)valueWrapper.get();
    }

    public static boolean containKey(Object key) {
        if (StringUtils.isEmpty((Object)key)) {
            return false;
        }
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).containKey(key);
    }

    public static List<String> getKeysLeftLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key;
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).getKeys(key);
    }

    public static List<String> getKeysRightLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = key + "*";
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).getKeys(key);
    }

    public static List<String> getKeysLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key + "*";
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).getKeys(key);
    }

    public static List<String> getKeys(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).getKeys(key);
    }

    public static List<String> scanKeys(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).scanKeys(key);
    }

    public static void evict(Object key) {
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).evict(key);
    }

    public static void evictKeysLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key + "*";
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).evictKeys(key);
    }

    public static void evictKeysLeftLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key;
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).evictKeys(key);
    }

    public static void evictKeysRightLike(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = key + "*";
        DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).evictKeys(key);
    }

    public static Long getKeyExpireTime(String key) {
        return DefaultCacheUtil.getCache(DEFAULT_CACHE_NAME).getKeyExpireTime(key);
    }
}

