/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisCacheWriter;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;

public class HussarRedisCache
extends RedisCache
implements HussarCache {
    private final RedisConnectionFactory redisConnectionFactory;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;
    private final String name;
    private final HussarRedisCacheWriter cacheWriter;

    protected HussarRedisCache(RedisCache cache, HussarRedisCacheWriter cacheWriter, RedisConnectionFactory redisConnectionFactory) {
        super(cache.getName(), (RedisCacheWriter)cacheWriter, cache.getCacheConfiguration());
        this.redisConnectionFactory = redisConnectionFactory;
        this.cacheConfig = cache.getCacheConfiguration();
        this.conversionService = this.cacheConfig.getConversionService();
        this.cacheWriter = cacheWriter;
        this.name = cache.getName();
    }

    @Nullable
    public Cache.ValueWrapper get(Object key) {
        return this.toValueWrapper(this.lookup(this.getRedisCacheKey(key)));
    }

    @Nullable
    public <T> T get(Object key, @Nullable Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(this.getRedisCacheKey(key)));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.cacheWriter.put(this.name, this.redisSerializeCacheKey(key), this.redisSerializeCacheValue(value), timeout);
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        Duration timeoutDuration = null;
        timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        this.put(key, value, timeoutDuration);
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Cache.ValueWrapper existingValue = this.get(this.getRedisCacheKey(key));
        if (existingValue == null) {
            this.put(key, value);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, Duration timeout) {
        Cache.ValueWrapper existingValue = this.get(this.getRedisCacheKey(key));
        if (existingValue == null) {
            this.put(key, value, timeout);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value, long seconds) {
        Duration timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        Cache.ValueWrapper existingValue = this.get(this.getRedisCacheKey(key));
        if (existingValue == null) {
            this.put(key, value, timeoutDuration);
            existingValue = new SimpleValueWrapper(value);
        }
        return existingValue;
    }

    @Override
    public boolean containKey(Object key) {
        return this.cacheWriter.execute(this.name, conection -> conection.exists((byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class)));
    }

    @Override
    public List<String> getKeys(String key) {
        return this.scanKeys(key);
    }

    @Override
    public List<String> scanKeys(String key) {
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class);
            List<Object> keys = new ArrayList();
            ArrayList finalKeys = new ArrayList();
            connection.scan(new ScanOptions.ScanOptionsBuilder().match(this.redisDeserializeCacheKey(pattern)).count(Integer.MAX_VALUE).build()).forEachRemaining(next -> finalKeys.add(this.redisDeserializeCacheKey((byte[])next)));
            keys = Optional.ofNullable(finalKeys).orElse(Collections.emptyList());
            return keys;
        });
    }

    public void evict(Object key) {
        this.cacheWriter.remove(this.name, (byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class));
    }

    @Override
    public void evictKeys(String key) {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class);
        this.cacheWriter.clean(this.name, pattern);
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class);
            Map<String, Object> mp = Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).stream().collect(Collectors.toMap(m -> this.redisDeserializeCacheKey((byte[])m), m -> this.deserializeCacheValue(connection.get(m))));
            return mp;
        });
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        Long timeout = this.cacheWriter.execute(this.name, conection -> conection.ttl((byte[])this.conversionService.convert((Object)this.createCacheKey(this.getRedisCacheKey(key)), byte[].class)));
        return timeout;
    }

    private byte[] redisSerializeCacheKey(Object key) {
        String cacheKey = this.getRedisCacheKey(key);
        cacheKey = this.createCacheKey(cacheKey);
        return this.serializeCacheKey(cacheKey);
    }

    private String getRedisCacheKey(Object key) {
        String cacheKey = this.convertKey(key);
        if (this.cacheConfig.usePrefix()) {
            String keyPrefixFor = this.cacheConfig.getKeyPrefixFor(this.name);
            boolean flag = StringUtil.startWith((CharSequence)cacheKey, (CharSequence)"*");
            if (flag) {
                cacheKey = StringUtil.removePrefix((CharSequence)cacheKey, (CharSequence)"*");
            }
            cacheKey = StringUtil.removePrefix((CharSequence)cacheKey, (CharSequence)keyPrefixFor);
            if (flag) {
                cacheKey = StringUtil.addPrefixIfNot((CharSequence)cacheKey, (CharSequence)"*");
            }
        }
        return cacheKey;
    }

    private byte[] redisSerializeCacheValue(Object value) {
        return this.serializeCacheValue(value);
    }

    private String redisDeserializeCacheKey(byte[] keyByte) {
        return (String)this.cacheConfig.getKeySerializationPair().read(ByteBuffer.wrap(keyByte));
    }
}

