/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.util;

import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.HussarCacheExceptionMessage;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.cache.support.NoCacheManagerException;
import java.util.Collection;
import java.util.Optional;
import org.springframework.util.StringUtils;

public abstract class AbstractHussarCacheOperator {
    private static HussarCacheManager getHussarCacheManager() {
        Optional<Object> bean = Optional.ofNullable(SpringContextUtil.getBean(HussarCacheManager.class));
        if (!bean.isPresent()) {
            throw new NoCacheManagerException(HussarCacheExceptionMessage.FAILED_TO_RETRIEVE_CACHE_OBJECT.getDesc());
        }
        return (HussarCacheManager)bean.get();
    }

    protected static HussarCache getCache(String cacheName) {
        if (StringUtils.isEmpty((Object)cacheName)) {
            throw new NoCacheManagerException(HussarCacheExceptionMessage.CACHE_NAME_CANNOT_EMPTY.getDesc());
        }
        return AbstractHussarCacheOperator.getHussarCacheManager().getCache(cacheName);
    }

    public static Collection<String> getCacheNames() {
        return AbstractHussarCacheOperator.getHussarCacheManager().getCacheNames();
    }
}

