/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.ehcache;

import com.jxdinfo.hussar.support.cache.support.HussarAbstractCacheManager;
import com.jxdinfo.hussar.support.cache.support.ehcache.HussarEhcacheCache;
import com.jxdinfo.hussar.support.cache.support.ehcache.listener.HussarEhcacheEventListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.event.CacheEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;

public class HussarEhcacheManager
extends HussarAbstractCacheManager {
    private CacheManager cacheManager;
    private HussarEhcacheEventListener hussarEhcacheEventListener;
    private static final ConcurrentMap<String, HussarEhcacheCache> CACHE_MAP = new ConcurrentHashMap<String, HussarEhcacheCache>();

    public HussarEhcacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Autowired
    public void setHussarEhcacheEventListener(HussarEhcacheEventListener hussarEhcacheEventListener) {
        this.hussarEhcacheEventListener = hussarEhcacheEventListener;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public HussarEhcacheCache cover(Cache cache) {
        return new HussarEhcacheCache((EhCacheCache)cache);
    }

    @Override
    public HussarEhcacheCache getCache(String cacheName) {
        HussarEhcacheCache cache = (HussarEhcacheCache)CACHE_MAP.get(cacheName);
        if (cache == null) {
            cache = this.getMissingCache(cacheName);
            CACHE_MAP.putIfAbsent(cacheName, cache);
            cache.getHussarCache().getCacheEventNotificationService().registerListener((CacheEventListener)this.hussarEhcacheEventListener);
        }
        return cache;
    }

    @Override
    public HussarEhcacheCache getMissingCache(String cacheName) {
        assert (this.cacheManager != null);
        Ehcache target = this.cacheManager.getEhcache(cacheName);
        if (target == null) {
            target = this.cacheManager.addCacheIfAbsent(cacheName);
        }
        return this.cover((Cache)new EhCacheCache(target));
    }

    @Override
    public Collection<String> getCacheNames() {
        String[] cacheNames = this.cacheManager.getCacheNames();
        if (cacheNames != null && cacheNames.length > 0) {
            return Arrays.asList(cacheNames);
        }
        return null;
    }
}

