/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.cache.support.redis.ClusterTypeEnum;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisCacheWriter;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisManager;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisProperties;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableConfigurationProperties(value={HussarRedisProperties.class})
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="redis")
public class HussarRedisAutoConfiguration
extends CachingConfigurerSupport {
    private final Logger logger = LoggerFactory.getLogger(HussarRedisAutoConfiguration.class);
    private HussarRedisProperties hussarRedisProperties;

    public HussarRedisAutoConfiguration(HussarRedisProperties hussarRedisProperties) {
        this.hussarRedisProperties = hussarRedisProperties;
    }

    @Bean
    public GenericObjectPoolConfig genericObjectPoolConfig(RedisProperties redisProperties) {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(redisProperties.getLettuce().getPool().getMaxIdle());
        genericObjectPoolConfig.setMinIdle(redisProperties.getLettuce().getPool().getMinIdle());
        genericObjectPoolConfig.setMaxTotal(redisProperties.getLettuce().getPool().getMaxActive());
        if (HussarUtils.isNotEmpty((Object)redisProperties.getLettuce().getPool().getMaxWait())) {
            genericObjectPoolConfig.setMaxWaitMillis(redisProperties.getLettuce().getPool().getMaxWait().toMillis());
        }
        if (HussarUtils.isNotEmpty((Object)redisProperties.getLettuce().getPool().getTimeBetweenEvictionRuns())) {
            genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(redisProperties.getLettuce().getPool().getTimeBetweenEvictionRuns().toMillis());
        }
        return genericObjectPoolConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    public LettuceConnectionFactory lettuceConnectionFactory(GenericObjectPoolConfig genericObjectPoolConfig, RedisProperties redisProperties) {
        LettuceConnectionFactory factory;
        if (this.hussarRedisProperties.getRedisCluster().equalsIgnoreCase(ClusterTypeEnum.CLUSTER.getKey())) {
            RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((Collection)redisProperties.getCluster().getNodes());
            redisClusterConfiguration.setMaxRedirects(redisProperties.getCluster().getMaxRedirects().intValue());
            redisClusterConfiguration.setPassword(redisProperties.getPassword());
            LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(redisProperties.getTimeout()).poolConfig(genericObjectPoolConfig).build();
            factory = new LettuceConnectionFactory(redisClusterConfiguration, (LettuceClientConfiguration)clientConfig);
            this.logger.debug("redis \u96c6\u7fa4\u542f\u52a8");
        } else if (this.hussarRedisProperties.getRedisCluster().equals(ClusterTypeEnum.SENTINEL.getKey())) {
            RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration(redisProperties.getSentinel().getMaster(), new HashSet(redisProperties.getSentinel().getNodes()));
            redisSentinelConfiguration.setPassword(redisProperties.getPassword());
            LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(redisProperties.getTimeout()).poolConfig(genericObjectPoolConfig).build();
            factory = new LettuceConnectionFactory(redisSentinelConfiguration, (LettuceClientConfiguration)clientConfig);
            this.logger.debug("redis \u54e8\u5175\u542f\u52a8");
        } else {
            RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
            redisStandaloneConfiguration.setDatabase(redisProperties.getDatabase());
            redisStandaloneConfiguration.setHostName(redisProperties.getHost());
            redisStandaloneConfiguration.setPort(redisProperties.getPort());
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)redisProperties.getPassword()));
            LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(redisProperties.getTimeout()).poolConfig(genericObjectPoolConfig).build();
            factory = new LettuceConnectionFactory(redisStandaloneConfiguration, this.getLettuceClientConfiguration(genericObjectPoolConfig, redisProperties));
            this.logger.debug("redis \u5355\u673a\u6a21\u5f0f\u8d77\u542f\u52a8");
        }
        factory.setShareNativeConnection(Boolean.FALSE.booleanValue());
        factory.setValidateConnection(Boolean.TRUE.booleanValue());
        return factory;
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(GenericObjectPoolConfig genericObjectPoolConfig, RedisProperties redisProperties) {
        ClusterTopologyRefreshOptions topologyRefreshOptions = ClusterTopologyRefreshOptions.builder().enableAllAdaptiveRefreshTriggers().adaptiveRefreshTriggersTimeout(Duration.ofSeconds(15L)).enablePeriodicRefresh(Duration.ofSeconds(20L)).build();
        return LettucePoolingClientConfiguration.builder().poolConfig(genericObjectPoolConfig).clientOptions((ClientOptions)ClusterClientOptions.builder().topologyRefreshOptions(topologyRefreshOptions).build()).commandTimeout(redisProperties.getTimeout()).build();
    }

    @Bean
    public RedisSerializer<String> stringRedisSerializer() {
        return new StringRedisSerializer();
    }

    @Bean
    public RedisSerializer jackson2JsonRedisSerializer() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JavaTimeModule());
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        jackson2JsonRedisSerializer.setObjectMapper(mapper);
        return jackson2JsonRedisSerializer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        template.setKeySerializer(this.jackson2JsonRedisSerializer());
        template.setHashKeySerializer(this.jackson2JsonRedisSerializer());
        template.setValueSerializer(this.jackson2JsonRedisSerializer());
        template.setHashValueSerializer(this.jackson2JsonRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(name={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        template.setKeySerializer(this.stringRedisSerializer());
        template.setHashKeySerializer(this.stringRedisSerializer());
        template.setValueSerializer(this.jackson2JsonRedisSerializer());
        template.setHashValueSerializer(this.jackson2JsonRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public RedisCacheManager cacheManager(RedisCacheWriter redisCacheWriter) {
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ZERO).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.stringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.jackson2JsonRedisSerializer())).disableCachingNullValues();
        return RedisCacheManager.builder((RedisCacheWriter)redisCacheWriter).cacheDefaults(defaultCacheConfig).build();
    }

    @Bean
    public HussarCacheManager hussarRedisManager(RedisCacheManager cacheManager, LettuceConnectionFactory lettuceConnectionFactor, RedisCacheWriter redisCacheWriter) {
        return new HussarRedisManager(cacheManager, (RedisConnectionFactory)lettuceConnectionFactor, (HussarRedisCacheWriter)redisCacheWriter);
    }

    @Bean
    public RedisCacheWriter redisCacheWriter(LettuceConnectionFactory lettuceConnectionFactory) {
        return HussarRedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)lettuceConnectionFactory);
    }
}

