/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.support.CacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.DefaultCacheNameCreator;
import com.jxdinfo.hussar.support.cache.support.ehcache.SpringEhCacheCacheManager;
import com.jxdinfo.hussar.support.cache.support.ehcache.listener.HussarEhcacheEventListener;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.properties.HussarSecurityProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@EnableConfigurationProperties(value={HussarCacheProperties.class})
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="ehcache", matchIfMissing=true)
public class EhCacheConfiguration
extends CachingConfigurerSupport {
    private HussarCacheProperties hussarCacheProperties;

    public EhCacheConfiguration(HussarCacheProperties hussarCacheProperties) {
        this.hussarCacheProperties = hussarCacheProperties;
    }

    @Bean
    public EhCacheManagerFactoryBean ehcacheManagerFactory() {
        ClassPathResource resource = new ClassPathResource("ehcache.xml");
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)resource);
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public SpringEhCacheCacheManager cacheManager(HussarTenantProperties hussarTenantProperties, HussarSecurityProperties hussarSecurityProperties, HussarCacheProperties hussarCacheProperties, CacheNameCreator cacheNameCreator) {
        SpringEhCacheCacheManager ehCacheCacheManager = new SpringEhCacheCacheManager();
        ehCacheCacheManager.setCacheManager(this.ehcacheManagerFactory().getObject());
        List<String> noControlCacheName = hussarCacheProperties.getNoControlCacheName();
        if (HussarUtils.isEmpty(noControlCacheName)) {
            noControlCacheName = new ArrayList<String>();
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        } else if (!noControlCacheName.contains(hussarSecurityProperties.getTokenName())) {
            noControlCacheName.add(hussarSecurityProperties.getTokenName());
        }
        hussarCacheProperties.setNoControlCacheName(noControlCacheName);
        ehCacheCacheManager.setHussarCacheProperties(hussarCacheProperties);
        ehCacheCacheManager.setCacheNameCreator(cacheNameCreator);
        ehCacheCacheManager.setHussarTenantProperties(hussarTenantProperties);
        return ehCacheCacheManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheNameCreator cacheNameCreator() {
        return new DefaultCacheNameCreator();
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new SimpleKeyGenerator();
    }

    @Bean
    public HussarEhcacheEventListener hussarEhcacheEventListener() {
        return new HussarEhcacheEventListener();
    }

    public CacheResolver cacheResolver() {
        return super.cacheResolver();
    }

    public CacheErrorHandler errorHandler() {
        return super.errorHandler();
    }
}

