/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.jxdinfo.hussar.support.cache.support.SpringAbstractTransactionSupportingCacheManager;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCache;
import com.jxdinfo.hussar.support.cache.support.redis.HussarSpringRedisCacheWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HussarSpringRedisCacheManger
extends SpringAbstractTransactionSupportingCacheManager {
    private final HussarSpringRedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;
    private final boolean allowInFlightCacheCreation;

    private HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
        this.allowInFlightCacheCreation = allowInFlightCacheCreation;
    }

    public HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        this(cacheWriter, defaultCacheConfiguration, true);
    }

    public HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, true, initialCacheNames);
    }

    public HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, boolean allowInFlightCacheCreation, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        for (String cacheName : initialCacheNames) {
            this.initialCacheConfiguration.put(cacheName, defaultCacheConfiguration);
        }
    }

    public HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, true);
    }

    public HussarSpringRedisCacheManger(HussarSpringRedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        this(cacheWriter, defaultCacheConfiguration, allowInFlightCacheCreation);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null!");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    public static HussarSpringRedisCacheManger create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return new HussarSpringRedisCacheManger(new HussarSpringRedisCacheWriter(connectionFactory), RedisCacheConfiguration.defaultCacheConfig());
    }

    public static HussarSpringRedisCacheManagerBuilder builder(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return HussarSpringRedisCacheManagerBuilder.fromConnectionFactory(connectionFactory);
    }

    public static HussarSpringRedisCacheManagerBuilder builder(HussarSpringRedisCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        return HussarSpringRedisCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    protected Collection<HussarSpringRedisCache> loadCaches() {
        LinkedList<HussarSpringRedisCache> caches = new LinkedList<HussarSpringRedisCache>();
        for (Map.Entry<String, RedisCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createRedisCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    @Override
    protected HussarSpringRedisCache getMissingCache(String name) {
        return this.allowInFlightCacheCreation ? this.createRedisCache(name, this.defaultCacheConfig) : null;
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        HashMap configurationMap = new HashMap(this.getCacheNames().size());
        this.getCacheNames().forEach(it -> {
            HussarSpringRedisCache cache = (HussarSpringRedisCache)HussarSpringRedisCache.class.cast(this.lookupCache((String)it));
            configurationMap.put(it, cache != null ? cache.getCacheConfiguration() : null);
        });
        return Collections.unmodifiableMap(configurationMap);
    }

    protected HussarSpringRedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new HussarSpringRedisCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public static class HussarSpringRedisCacheManagerBuilder {
        private final HussarSpringRedisCacheWriter cacheWriter;
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        private final Map<String, RedisCacheConfiguration> initialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private boolean enableTransactions;
        boolean allowInFlightCacheCreation = true;

        private HussarSpringRedisCacheManagerBuilder(HussarSpringRedisCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static HussarSpringRedisCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
            return HussarSpringRedisCacheManger.builder(new HussarSpringRedisCacheWriter(connectionFactory));
        }

        public static HussarSpringRedisCacheManagerBuilder fromCacheWriter(HussarSpringRedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            return new HussarSpringRedisCacheManagerBuilder(cacheWriter);
        }

        public HussarSpringRedisCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public HussarSpringRedisCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public HussarSpringRedisCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, (String)"CacheNames must not be null!");
            cacheNames.forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public HussarSpringRedisCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, (String)"CacheConfigurations must not be null!");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull((Object)configuration, (String)String.format("RedisCacheConfiguration for cache %s must not be null!", cacheName)));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public HussarSpringRedisCacheManagerBuilder withCacheConfiguration(String cacheName, RedisCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, (String)"CacheName must not be null!");
            Assert.notNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public HussarSpringRedisCacheManagerBuilder disableCreateOnMissingCache() {
            this.allowInFlightCacheCreation = false;
            return this;
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public Optional<RedisCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public HussarSpringRedisCacheManger build() {
            HussarSpringRedisCacheManger cm = new HussarSpringRedisCacheManger(this.cacheWriter, this.defaultCacheConfiguration, this.initialCaches, this.allowInFlightCacheCreation);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

