/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.redis;

import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.redis.HussarRedisCacheWriter;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class HussarRedisCache
extends RedisCache
implements HussarCache {
    private final RedisConnectionFactory redisConnectionFactory;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;
    private final String name;
    private final HussarRedisCacheWriter cacheWriter;

    protected HussarRedisCache(RedisCache cache, HussarRedisCacheWriter cacheWriter, RedisConnectionFactory redisConnectionFactory) {
        super(cache.getName(), (RedisCacheWriter)cacheWriter, cache.getCacheConfiguration());
        this.redisConnectionFactory = redisConnectionFactory;
        this.cacheConfig = cache.getCacheConfiguration();
        this.conversionService = this.cacheConfig.getConversionService();
        this.cacheWriter = cacheWriter;
        this.name = cache.getName();
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.cacheWriter.put(this.name, this.redisSerializeCacheKey(key), this.redisSerializeCacheValue(value), timeout);
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        Duration timeoutDuration = null;
        timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        this.put(key, value, timeoutDuration);
    }

    @Override
    public boolean containKey(Object key) {
        return this.cacheWriter.execute(this.name, conection -> conection.exists((byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class)));
    }

    @Override
    public List<String> getKeys(String key) {
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
            List keys = Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).stream().map(m -> this.redisDeserializeCacheKey((byte[])m)).collect(Collectors.toList());
            return keys;
        });
    }

    @Override
    public void evictKeys(String key) {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
        this.cacheWriter.clean(this.name, pattern);
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        return this.cacheWriter.execute(this.name, connection -> {
            byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class);
            Map<String, Object> mp = Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).stream().collect(Collectors.toMap(m -> this.redisDeserializeCacheKey((byte[])m), m -> this.deserializeCacheValue(connection.get(m))));
            return mp;
        });
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        Long timeout = this.cacheWriter.execute(this.name, conection -> conection.ttl((byte[])this.conversionService.convert((Object)this.createCacheKey(key), byte[].class)));
        return timeout;
    }

    private byte[] redisSerializeCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private byte[] redisSerializeCacheValue(Object value) {
        return this.serializeCacheValue(value);
    }

    private String redisDeserializeCacheKey(byte[] keyByte) {
        return (String)this.cacheConfig.getKeySerializationPair().read(ByteBuffer.wrap(keyByte));
    }
}

