/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.support.ehcache;

import com.jxdinfo.hussar.support.cache.support.HussarCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.util.NumberUtils;

public class HussarEhcacheCache
extends EhCacheCache
implements HussarCache {
    private Ehcache ehcache;

    public HussarEhcacheCache(EhCacheCache ehcache) {
        super(ehcache.getNativeCache());
        this.ehcache = ehcache.getNativeCache();
    }

    public Ehcache getHussarCache() {
        return this.ehcache;
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        Element element = new Element(key, value);
        element.setEternal(false);
        element.setTimeToLive(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        this.ehcache.put(element);
    }

    @Override
    public void put(Object key, Object value, long seconds) {
        Duration timeoutDuration = null;
        timeoutDuration = seconds > 0L ? Duration.ofSeconds(seconds) : Duration.ZERO;
        this.put(key, value, timeoutDuration);
    }

    @Override
    public boolean containKey(Object key) {
        Element elementValue = this.ehcache.getQuiet(key);
        return elementValue != null;
    }

    @Override
    public List<String> getKeys(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Results results = this.execKeyQueryLike(key);
        for (Result r : results.all()) {
            list.add(r.getKey().toString());
        }
        return list;
    }

    @Override
    public void evictKeys(String key) {
        Results results = this.execKeyQueryLike(key);
        for (Result r : results.all()) {
            this.ehcache.remove(r.getKey());
        }
    }

    @Override
    public Map<String, Object> getKeysAndValues(String key) {
        Results results = this.execKeyQueryLike(key);
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Result r : results.all()) {
            tmp.put("value", r.getValue());
            tmp.put("key", r.getKey());
        }
        return tmp;
    }

    @Override
    public Long getKeyExpireTime(Object key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        long time = element.getExpirationTime();
        if (time == Long.MAX_VALUE) {
            return -1L;
        }
        return Duration.ofMillis(element.getExpirationTime() - System.currentTimeMillis()).getSeconds();
    }

    private Results execKeyQueryLike(String key) {
        Query query = this.ehcache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = this.ehcache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        return results;
    }
}

