/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.cache.config;

import com.jxdinfo.hussar.support.cache.support.HussarCacheManager;
import com.jxdinfo.hussar.support.cache.support.ehcache.HussarEhcacheManager;
import com.jxdinfo.hussar.support.cache.support.ehcache.listener.HussarEhcacheEventListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="ehcache", matchIfMissing=true)
public class EhCacheConfiguration
extends CachingConfigurerSupport {
    @Bean
    public EhCacheManagerFactoryBean ehcacheManagerFactory() {
        ClassPathResource resource = new ClassPathResource("ehcache.xml");
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)resource);
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public EhCacheCacheManager cacheManager() {
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager();
        ehCacheCacheManager.setCacheManager(this.ehcacheManagerFactory().getObject());
        return ehCacheCacheManager;
    }

    @Bean
    public HussarCacheManager hussarEhcacheManager(EhCacheCacheManager cacheManager) {
        return new HussarEhcacheManager(cacheManager.getCacheManager());
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new SimpleKeyGenerator();
    }

    @Bean
    public HussarEhcacheEventListener hussarEhcacheEventListener() {
        return new HussarEhcacheEventListener();
    }

    public CacheResolver cacheResolver() {
        return super.cacheResolver();
    }

    public CacheErrorHandler errorHandler() {
        return super.errorHandler();
    }
}

