/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.retry.aspect;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.platform.core.support.service.RetryInfoService;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.Exceptions;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockExecutionStrategy;
import com.jxdinfo.hussar.support.retry.core.annotations.HussarRetry;
import com.jxdinfo.hussar.support.retry.core.dto.RetryDto;
import com.jxdinfo.hussar.support.retry.core.enums.HussarRetryStatus;
import com.jxdinfo.hussar.support.retry.core.enums.HussarRetryStrategy;
import com.jxdinfo.hussar.support.retry.core.events.HussarRetryStoreEvent;
import com.jxdinfo.hussar.support.retry.core.exception.HussarRetryException;
import com.jxdinfo.hussar.support.retry.core.extension.BackOffStrategy;
import com.jxdinfo.hussar.support.retry.core.properties.HussarRetryProperties;
import com.jxdinfo.hussar.support.retry.core.utils.AnnotationExtractor;
import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

@Aspect
public class HussarRetryAspect
implements Ordered,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HussarRetryAspect.class);
    private static final String LOCK_KEY_PREFIX = "hussar-retry";
    private final ScheduledExecutorService retryExecutorService;
    private final RetryRegistry retryRegistry;
    private final HussarRetryProperties retryProperties;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final HussarLockManager lockManager;
    private final RetryInfoService retryInfoService;

    public HussarRetryAspect(RetryRegistry retryRegistry, HussarRetryProperties retryProperties, ApplicationEventPublisher applicationEventPublisher, HussarLockManager lockManager, RetryInfoService retryInfoService, @Nullable ContextAwareScheduledThreadPoolExecutor contextAwareScheduledThreadPoolExecutor) {
        this.retryRegistry = retryRegistry;
        this.retryProperties = retryProperties;
        this.applicationEventPublisher = applicationEventPublisher;
        this.lockManager = lockManager;
        this.retryInfoService = retryInfoService;
        this.retryExecutorService = contextAwareScheduledThreadPoolExecutor != null ? contextAwareScheduledThreadPoolExecutor : Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    }

    @Around(value="@annotation(hussarRetry)", argNames="proceedingJoinPoint, hussarRetry")
    public Object retryAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable HussarRetry hussarRetry) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (hussarRetry == null) {
            hussarRetry = this.getRetryAnnotation(proceedingJoinPoint);
        }
        if (hussarRetry == null) {
            return proceedingJoinPoint.proceed();
        }
        TenantDetails tenantDetails = HussarTenantContextHolder.getTenant();
        String serviceName = this.retryInfoService.getServiceName();
        String parameters = this.convertParameters(proceedingJoinPoint.getArgs(), method.getGenericParameterTypes());
        String lockKey = this.generateKey(tenantDetails.getTenantCode(), serviceName, method.getDeclaringClass().getName(), method.getName(), parameters);
        HussarLockGuard lockGuard = this.lockManager.acquire(HussarLockType.REENTRANT_LOCK, HussarLockExecutionStrategy.UNLIMITED, lockKey, Duration.ofSeconds(5L));
        if (null == lockGuard) {
            throw new HussarException("\u5df2\u6709\u76f8\u540c\u6570\u636e\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        try {
            Retry retry = this.getOrCreateRetry(methodName, hussarRetry);
            Class<?> returnType = method.getReturnType();
            try {
                Object result = this.proceed(proceedingJoinPoint, retry, returnType);
                this.doCallback(hussarRetry.callback(), proceedingJoinPoint, HussarRetryStatus.SUCCESS, null);
                Object object = result;
                return object;
            }
            catch (Exception ex) {
                this.handleJoinPointFailure(ex, tenantDetails.getTenantCode(), serviceName, method, parameters);
                this.doCallback(hussarRetry.callback(), proceedingJoinPoint, HussarRetryStatus.FAILURE, ex);
                throw ex.getCause() != null ? ex.getCause() : ex;
            }
        }
        finally {
            lockGuard.releaseLock();
        }
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, Retry retry, Class<?> returnType) throws Throwable {
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, retry);
        }
        return this.handleDefaultJoinPoint(proceedingJoinPoint, retry);
    }

    private Retry getOrCreateRetry(String methodName, HussarRetry hussarRetry) {
        Retry retry = this.retryRegistry.retry(hussarRetry.serviceName(), this.createRetryConfig(hussarRetry));
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved retry '{}' with max attempts rate '{}'  for method: '{}'", new Object[]{hussarRetry.serviceName(), retry.getRetryConfig().getMaxAttempts(), methodName});
        }
        return retry;
    }

    private RetryConfig createRetryConfig(HussarRetry hussarRetry) {
        return RetryConfig.custom().maxAttempts(hussarRetry.maxAttempts() > 0 ? hussarRetry.maxAttempts() : this.retryProperties.getMaxAttempts()).intervalFunction(this.intervalFunction(hussarRetry)).retryOnException(ex -> ex instanceof HussarRetryException).build();
    }

    private IntervalFunction intervalFunction(HussarRetry hussarRetry) {
        double randomFactor;
        double multiplier;
        long interval;
        HussarRetryStrategy strategy = hussarRetry.strategy();
        long l = interval = hussarRetry.interval() > 0L ? hussarRetry.interval() : this.retryProperties.getInterval();
        if (HussarRetryStrategy.FIXED.equals((Object)strategy)) {
            return IntervalFunction.of((long)interval);
        }
        double d = multiplier = hussarRetry.multiplier() > 0.0 ? hussarRetry.multiplier() : this.retryProperties.getMultiplier();
        if (HussarRetryStrategy.EXPONENTIAL.equals((Object)strategy)) {
            return IntervalFunction.ofExponentialBackoff((long)interval, (double)multiplier);
        }
        double d2 = randomFactor = hussarRetry.randomFactor() > 0.0 ? hussarRetry.randomFactor() : this.retryProperties.getRandomFactor();
        if (HussarRetryStrategy.RANDOM.equals((Object)strategy)) {
            return IntervalFunction.ofRandomized((long)interval, (double)randomFactor);
        }
        if (HussarRetryStrategy.CUSTOM.equals((Object)strategy)) {
            return attempt -> {
                if ((long)attempt.intValue() < 1L) {
                    throw new IllegalArgumentException("Illegal argument attempt: " + attempt);
                }
                ServiceLoader<BackOffStrategy> strategyServiceLoader = ServiceLoader.load(BackOffStrategy.class);
                Iterator<BackOffStrategy> strategyIterator = strategyServiceLoader.iterator();
                if (strategyIterator.hasNext()) {
                    return strategyServiceLoader.iterator().next().computeDelayBeforeNextRetry(attempt.intValue(), interval);
                }
                return interval;
            };
        }
        return IntervalFunction.ofExponentialRandomBackoff((long)interval, (double)multiplier, (double)randomFactor);
    }

    @Nullable
    private HussarRetry getRetryAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (proceedingJoinPoint.getTarget() instanceof Proxy) {
            logger.debug("The retry annotation is kept on a interface which is acting as a proxy");
            return (HussarRetry)AnnotationExtractor.extractAnnotationFromProxy((Object)proceedingJoinPoint.getTarget(), HussarRetry.class);
        }
        return (HussarRetry)AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), HussarRetry.class);
    }

    private Object handleDefaultJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Retry retry) throws Throwable {
        return retry.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Retry retry) {
        return retry.executeCompletionStage(this.retryExecutorService, () -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    private void handleJoinPointFailure(Throwable ex, String tenantCode, String serviceName, Method method, String parameters) {
        logger.debug("\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570\u4ecd\u7136\u5931\u8d25\uff0c\u7ec4\u88c5\u624b\u52a8\u91cd\u8bd5\u8bb0\u5f55\u4fe1\u606f\u5e76\u53d1\u5e03\u91cd\u8bd5\u4fdd\u5b58\u4e8b\u4ef6");
        RetryDto retryDto = RetryDto.builder().tenantCode(tenantCode).connName(HussarTenantContextHolder.getConnName()).pluginId(this.retryInfoService.getPluginId()).className(method.getDeclaringClass().getName()).methodName(method.getName()).parameters(parameters).exceptionType(ex.getClass().getName()).exceptionMessage(Exceptions.getStackTraceAsString((Throwable)ex)).serviceName(serviceName).instanceIp(IpUtils.CURRENT_LOCAL_IP).instancePort(this.retryInfoService.getServerPort()).retryStatus(Integer.valueOf(0)).build();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new HussarRetryStoreEvent((Object)this, retryDto));
    }

    private void doCallback(String callbackMethodName, ProceedingJoinPoint proceedingJoinPoint, HussarRetryStatus hussarRetryStatus, Exception ex) {
        logger.debug("\u5904\u7406\u56de\u8c03\u65b9\u6cd5\uff0c\u56de\u8c03\u65b9\u6cd5\u540d\u79f0\uff1a{}, \u91cd\u8bd5\u72b6\u6001\uff1a{}", (Object)callbackMethodName, (Object)hussarRetryStatus);
        if (HussarUtils.isBlank((CharSequence)callbackMethodName)) {
            return;
        }
        Object target = proceedingJoinPoint.getTarget();
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Type[] types = signature.getMethod().getGenericParameterTypes();
        Object[] params = proceedingJoinPoint.getArgs();
        Class[] paramTypes = new Class[types.length + 2];
        Object[] callbackParams = new Object[params.length + 2];
        for (int i = 0; i < types.length; ++i) {
            paramTypes[i] = HussarRetryAspect.getRawClass(types[i]);
            callbackParams[i] = params[i];
        }
        paramTypes[types.length] = HussarRetryStatus.class;
        paramTypes[types.length + 1] = Exception.class;
        callbackParams[types.length] = hussarRetryStatus;
        callbackParams[types.length + 1] = ex;
        Method callbackMethod = ReflectionUtils.findMethod(target.getClass(), (String)callbackMethodName, (Class[])paramTypes);
        if (HussarUtils.isEmpty((Object)callbackMethod)) {
            logger.info("{}\u7c7b\u4e2d\u4e0d\u5b58\u5728{}\u65b9\u6cd5\uff0c\u65b9\u6cd5\u53c2\u6570\u4e3a{}\uff0c\u56de\u8c03\u5931\u8d25\uff01", new Object[]{target.getClass().getSimpleName(), callbackMethodName, paramTypes});
            return;
        }
        this.retryExecutorService.submit(() -> {
            ReflectionUtils.makeAccessible((Method)callbackMethod);
            ReflectionUtils.invokeMethod((Method)callbackMethod, (Object)target, (Object[])callbackParams);
        });
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType().getClass();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private String convertParameters(Object[] args, Type[] paramTypes) {
        if (HussarUtils.isEmpty((Object[])args)) {
            return null;
        }
        ArrayList typeDataList = Lists.newArrayListWithCapacity((int)args.length);
        for (int i = 0; i < args.length; ++i) {
            HashMap typeDataMap = Maps.newHashMapWithExpectedSize((int)2);
            typeDataMap.put("type", paramTypes[i].getTypeName());
            typeDataMap.put("value", JsonUtil.toJson((Object)args[i]));
            typeDataList.add(typeDataMap);
        }
        return JsonUtil.toJson((Object)typeDataList);
    }

    private String generateKey(String tenantCode, String serviceName, String className, String methodName, String parameters) {
        return "hussar-retry:" + SM3Util.digest((String)Joiner.on((String)":").join((Object)tenantCode, (Object)serviceName, new Object[]{className, methodName, parameters}));
    }

    public int getOrder() {
        return 0x7FFFFFFB;
    }

    @Override
    public void close() {
        this.retryExecutorService.shutdown();
        try {
            if (!this.retryExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.retryExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            if (!this.retryExecutorService.isTerminated()) {
                this.retryExecutorService.shutdownNow();
            }
            Thread.currentThread().interrupt();
        }
    }
}

