/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.retry.autoconfigure;

import com.jxdinfo.hussar.platform.core.support.service.RetryInfoService;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.retry.aspect.HussarRetryAspect;
import com.jxdinfo.hussar.support.retry.conditions.HussarRetryConditional;
import com.jxdinfo.hussar.support.retry.core.properties.HussarRetryProperties;
import com.jxdinfo.hussar.support.retry.core.service.HussarRetryExecuteService;
import com.jxdinfo.hussar.support.retry.core.utils.AspectJOnClasspathCondition;
import com.jxdinfo.hussar.support.retry.listener.HussarRetryEventListener;
import com.jxdinfo.hussar.support.retry.support.service.DefaultRetryInfoService;
import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.retry.RetryRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@Conditional(value={HussarRetryConditional.class})
@EnableConfigurationProperties(value={HussarRetryProperties.class})
@EnableAspectJAutoProxy(exposeProxy=true)
public class HussarRetryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RetryRegistry retryRegistry() {
        return RetryRegistry.ofDefaults();
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public HussarRetryAspect retryAspect(RetryRegistry retryRegistry, HussarRetryProperties retryProperties, ApplicationEventPublisher applicationEventPublisher, HussarLockManager hussarLockManager, RetryInfoService retryInfoService, @Autowired(required=false) ContextAwareScheduledThreadPoolExecutor contextAwareScheduledThreadPoolExecutor) {
        return new HussarRetryAspect(retryRegistry, retryProperties, applicationEventPublisher, hussarLockManager, retryInfoService, contextAwareScheduledThreadPoolExecutor);
    }

    @Bean
    public HussarRetryEventListener hussarRetryEventListener() {
        return new HussarRetryEventListener();
    }

    @Bean
    public HussarRetryExecuteService retryExecuteService() {
        return new HussarRetryExecuteService();
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryInfoService retryInfoService() {
        return new DefaultRetryInfoService();
    }
}

