/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.retry.db.service.impl;

import com.jxdinfo.hussar.support.retry.core.dto.RetryDto;
import com.jxdinfo.hussar.support.retry.core.service.RetryService;
import com.jxdinfo.hussar.support.retry.db.RetryStatus;
import com.jxdinfo.hussar.support.retry.db.model.HussarRetryEntity;
import com.jxdinfo.hussar.support.retry.db.service.HussarRetryHistService;
import com.jxdinfo.hussar.support.retry.db.service.HussarRetryService;
import com.jxdinfo.hussar.support.retry.db.utils.DTOModelTransformUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetryServiceImpl
implements RetryService {
    @Autowired
    private HussarRetryService hussarRetryService;
    @Autowired
    private HussarRetryHistService retryHistService;

    public void save(RetryDto retryDto) {
        HussarRetryEntity retryEntity = DTOModelTransformUtils.dto2RetryModel(retryDto);
        this.hussarRetryService.save(retryEntity);
    }

    @HussarTransactional
    public void saveHist(RetryDto retryDto) {
        Long id = retryDto.getId();
        if (Objects.equals(retryDto.getRetryStatus(), RetryStatus.RETRY_SUCCESS.getCode())) {
            this.hussarRetryService.removeById(id);
        }
        this.retryHistService.save(DTOModelTransformUtils.dto2RetryHistModel(retryDto));
    }
}

