/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.retry.db.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.retry.core.dto.RetryDto;
import com.jxdinfo.hussar.support.retry.core.service.RetryExecuteService;
import com.jxdinfo.hussar.support.retry.db.model.HussarRetryEntity;
import com.jxdinfo.hussar.support.retry.db.service.HussarRetryService;
import com.jxdinfo.hussar.support.retry.db.service.RetryFrontService;
import com.jxdinfo.hussar.support.retry.db.utils.DTOModelTransformUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class RetryFrontServiceImpl
implements RetryFrontService {
    @Autowired
    private HussarRetryService hussarRetryService;
    @Autowired
    private RetryExecuteService retryExecuteService;

    @Override
    public IPage<RetryDto> listPage(IPage<RetryDto> retryDtoIPage, RetryDto retryDto) {
        Page retryEntityIPage = new Page(retryDtoIPage.getCurrent(), retryDtoIPage.getSize());
        HussarRetryEntity retryParam = DTOModelTransformUtils.dto2RetryModel(retryDto);
        retryEntityIPage = this.hussarRetryService.page((IPage)retryEntityIPage, (Wrapper)Wrappers.query((Object)retryParam));
        Page result = new Page(retryEntityIPage.getCurrent(), retryEntityIPage.getSize(), retryEntityIPage.getTotal());
        if (retryEntityIPage.getTotal() == 0L) {
            return result;
        }
        List records = retryEntityIPage.getRecords();
        ArrayList retryDtoList = Lists.newArrayListWithCapacity((int)records.size());
        for (HussarRetryEntity retryEntity : records) {
            retryDtoList.add(DTOModelTransformUtils.retryModel2Dto(retryEntity));
        }
        result.setRecords((List)retryDtoList);
        return result;
    }

    @Override
    public RetryDto info(Long id) {
        HussarRetryEntity retryEntity = (HussarRetryEntity)this.hussarRetryService.getById(id);
        if (HussarUtils.isEmpty((Object)retryEntity)) {
            return null;
        }
        return DTOModelTransformUtils.retryModel2Dto(retryEntity);
    }

    @Override
    public void remove(Long id) {
        this.hussarRetryService.removeById(id);
    }

    @Override
    public void execute(Long id) {
        HussarRetryEntity retryEntity = (HussarRetryEntity)this.hussarRetryService.getById(id);
        if (HussarUtils.isEmpty((Object)retryEntity)) {
            return;
        }
        RetryDto retryDto = DTOModelTransformUtils.retryModel2Dto(retryEntity);
        this.retryExecuteService.execute(retryDto);
    }
}

