/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.config.redis;

import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.redis.ClusterTypeEnum;
import com.jxdinfo.hussar.support.mq.config.redis.resources.HussarMQDefaultRedisResources;
import com.jxdinfo.hussar.support.mq.config.redis.resources.HussarMQRedisResources;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.constants.HussarRedisMQConstants;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.context.annotation.Bean;

public class HussarMQRedisResourcesConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={HussarMQRedisResources.class})
    public HussarMQRedisResources hussarRedisMQConnectionFactoryContainer(HussarRedisMQProperties hussarRedisMQProperties, HussarCacheProperties hussarCacheProperties, ObjectProvider<RedisProperties> redisPropertiesProvider) {
        HussarRedisMQProperties.RedisConnectionProperties redisProperties;
        HussarRedisMQProperties.RedisConnectionProperties redisConnectionProperties = hussarRedisMQProperties.getConnection();
        boolean useDefault = Optional.ofNullable(redisConnectionProperties).map(HussarRedisMQProperties.RedisConnectionProperties::isUseDefault).orElse(true);
        Object object = redisProperties = useDefault ? (RedisProperties)redisPropertiesProvider.getIfAvailable() : redisConnectionProperties;
        if (redisProperties == null) {
            redisProperties = new RedisProperties();
        }
        redisProperties = this.createRedisPropertiesProxy(hussarRedisMQProperties, (RedisProperties)redisProperties);
        hussarCacheProperties = this.createHussarCachePropertiesProxy(hussarRedisMQProperties, hussarCacheProperties, (RedisProperties)redisProperties);
        return this.createRedisResources(hussarRedisMQProperties, hussarCacheProperties, (RedisProperties)redisProperties);
    }

    protected HussarMQRedisResources createRedisResources(HussarRedisMQProperties hussarRedisMQProperties, HussarCacheProperties hussarCacheProperties, RedisProperties redisProperties) {
        return HussarMQDefaultRedisResources.create(redisProperties, hussarCacheProperties);
    }

    protected RedisProperties createRedisPropertiesProxy(HussarRedisMQProperties hussarRedisMQProperties, RedisProperties redisProperties) {
        MethodInterceptor getTimeoutInterceptor = (obj, method, args, proxy) -> this.getTimeout(hussarRedisMQProperties, redisProperties);
        return this.createProxy(redisProperties, Collections.singletonMap("getTimeout", getTimeoutInterceptor));
    }

    protected HussarCacheProperties createHussarCachePropertiesProxy(HussarRedisMQProperties hussarRedisMQProperties, HussarCacheProperties hussarCacheProperties, RedisProperties redisProperties) {
        MethodInterceptor getRedisClusterInterceptor = (obj, method, args, proxy) -> this.getRedisCluster(hussarRedisMQProperties, hussarCacheProperties, redisProperties);
        return this.createProxy(hussarCacheProperties, Collections.singletonMap("getRedisCluster", getRedisClusterInterceptor));
    }

    private <T> T createProxy(T target, Map<String, MethodInterceptor> interceptors) {
        Enhancer enhancer = new Enhancer();
        enhancer.setUseCache(false);
        enhancer.setSuperclass(target.getClass());
        enhancer.setClassLoader(target.getClass().getClassLoader());
        int index = 0;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        Callback[] callbacks = new Callback[1 + interceptors.size()];
        callbacks[index++] = proxy -> target;
        for (Map.Entry<String, MethodInterceptor> entry : interceptors.entrySet()) {
            indices.put(entry.getKey(), index);
            callbacks[index++] = (Callback)entry.getValue();
        }
        enhancer.setCallbacks(callbacks);
        enhancer.setCallbackFilter(method -> {
            Integer idx = (Integer)indices.get(method.getName());
            return idx != null ? idx : 0;
        });
        return (T)enhancer.create();
    }

    protected Duration getTimeout(HussarRedisMQProperties hussarRedisMQProperties, RedisProperties properties) {
        Duration interval = Optional.ofNullable(hussarRedisMQProperties.getPollInterval()).filter(duration -> duration.compareTo(Duration.ZERO) > 0).orElse(HussarRedisMQConstants.DEFAULT_INTERVAL);
        Duration timeout = Optional.ofNullable(properties.getTimeout()).filter(duration -> duration.compareTo(Duration.ZERO) > 0).orElseGet(() -> Duration.ofSeconds(60L));
        return interval.plus(timeout);
    }

    protected String getRedisCluster(HussarRedisMQProperties hussarRedisMQProperties, HussarCacheProperties hussarCacheProperties, RedisProperties redisProperties) {
        boolean useDefault = Optional.ofNullable(hussarRedisMQProperties.getConnection()).map(HussarRedisMQProperties.RedisConnectionProperties::isUseDefault).orElse(true);
        String redisCluster = useDefault ? hussarCacheProperties.getRedisCluster() : hussarRedisMQProperties.getConnection().getRedisCluster();
        if (redisCluster == null) {
            redisCluster = redisProperties.getSentinel() != null ? ClusterTypeEnum.SENTINEL.getKey() : (redisProperties.getCluster() != null ? ClusterTypeEnum.CLUSTER.getKey() : ClusterTypeEnum.STANDALONE.getKey());
        }
        return redisCluster;
    }
}

