/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.config;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.support.mq.config.redis.HussarMQRedisResourcesConfiguration;
import com.jxdinfo.hussar.support.mq.config.redis.resources.HussarMQRedisResources;
import com.jxdinfo.hussar.support.mq.redis.HussarRedisMQManager;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.message.HussarRedisMQMessageCodec;
import com.jxdinfo.hussar.support.mq.shared.HussarMQThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@ConditionalOnProperty(name={"hussar.mq.type"}, havingValue="redis")
@EnableConfigurationProperties(value={HussarRedisMQProperties.class})
@Import(value={HussarMQRedisResourcesConfiguration.class})
public class HussarMQRedisConfiguration {
    @Bean
    public HussarRedisMQManager hussarMQManager(HussarRedisMQProperties properties, HussarMQRedisResources resources, ObjectProvider<SeqBuilder> hussarSeqBuilderProvider) {
        HussarRedisMQMessageCodec messageCodec = this.redisMessageCodec(properties);
        RedisTemplate<String, Object> redisTemplate = this.redisTemplate(properties, resources, messageCodec);
        ExecutorService executorService = this.executorService(properties);
        SeqBuilder hussarSeqBuilder = (SeqBuilder)hussarSeqBuilderProvider.getIfAvailable();
        return new HussarRedisMQManager(properties, redisTemplate, messageCodec, executorService, hussarSeqBuilder);
    }

    private RedisTemplate<String, Object> redisTemplate(HussarRedisMQProperties properties, HussarMQRedisResources resources, HussarRedisMQMessageCodec messageCodec) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(resources.getConnectionFactory());
        messageCodec.configureRedisTemplate(redisTemplate);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    private HussarRedisMQMessageCodec redisMessageCodec(HussarRedisMQProperties properties) {
        return new HussarRedisMQMessageCodec(properties);
    }

    private ExecutorService executorService(HussarRedisMQProperties properties) {
        return Executors.newCachedThreadPool((ThreadFactory)new HussarMQThreadFactory());
    }
}

