/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.config.redis.resources;

import com.jxdinfo.hussar.support.cache.config.HussarRedisAutoConfiguration;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.mq.config.redis.resources.HussarMQRedisResources;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public class HussarMQDefaultRedisResources
implements HussarMQRedisResources {
    private final RedisProperties properties;
    private final LettuceConnectionFactory connectionFactory;

    protected HussarMQDefaultRedisResources(RedisProperties properties, LettuceConnectionFactory connectionFactory) {
        this.properties = properties;
        this.connectionFactory = connectionFactory;
    }

    public static HussarMQDefaultRedisResources create(RedisProperties redisProperties, HussarCacheProperties hussarCacheProperties) {
        HussarRedisAutoConfiguration configuration = new HussarRedisAutoConfiguration(hussarCacheProperties);
        GenericObjectPoolConfig genericObjectPoolConfig = configuration.genericObjectPoolConfig(redisProperties);
        LettuceConnectionFactory connectionFactory = configuration.lettuceConnectionFactory(genericObjectPoolConfig, redisProperties);
        return new HussarMQDefaultRedisResources(redisProperties, connectionFactory);
    }

    @Override
    public RedisProperties getProperties() {
        return this.properties;
    }

    public LettuceConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void destroy() throws Exception {
        this.connectionFactory.destroy();
    }

    public void afterPropertiesSet() throws Exception {
        this.connectionFactory.afterPropertiesSet();
    }
}

