/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.standalone.queue;

import com.jxdinfo.hussar.support.mq.standalone.queue.HussarMQStandaloneQueue;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.springframework.lang.NonNull;

public class HussarMQMemoryQueue
implements HussarMQStandaloneQueue {
    private static final String PRODUCER_NAME_PREFIX = "p-";
    private static final String CONSUMER_NAME_PREFIX = "c-";
    private static final String DESCRIPTION_SEPARATOR = " #";
    private final String key;
    private final int capacity;
    private final LinkedBlockingQueue<Message> queue;
    private final AtomicInteger producerCounter = new AtomicInteger(0);
    private final AtomicInteger consumerCounter = new AtomicInteger(0);
    private final Set<String> producers = ConcurrentHashMap.newKeySet();
    private final Set<String> consumers = ConcurrentHashMap.newKeySet();

    public HussarMQMemoryQueue(String key) {
        this(key, 0);
    }

    public HussarMQMemoryQueue(String key, int capacity) {
        this.key = key;
        if (capacity > 0) {
            this.capacity = capacity;
            this.queue = new LinkedBlockingQueue(capacity);
        } else {
            this.capacity = 0;
            this.queue = new LinkedBlockingQueue();
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean offer(@NonNull String producer, @NonNull byte[] data, Duration timeout) {
        if (!this.producers.contains(producer)) {
            throw new IllegalArgumentException("producer " + producer + " not registered");
        }
        Message message = new Message(producer, data);
        try {
            if (timeout == null || timeout.compareTo(Duration.ZERO) <= 0) {
                this.queue.put(message);
                return true;
            }
            return this.queue.offer(message, timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException((Throwable)ex);
        }
    }

    @Override
    public byte[] poll(@NonNull String consumer, Duration timeout) {
        Message message;
        if (!this.consumers.contains(consumer)) {
            throw new IllegalArgumentException("consumer " + consumer + " not registered");
        }
        try {
            message = timeout == null || timeout.compareTo(Duration.ZERO) <= 0 ? this.queue.take() : this.queue.poll(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException((Throwable)ex);
        }
        return message != null ? message.getData() : null;
    }

    @Override
    public String registerProducer(String description) {
        String name = PRODUCER_NAME_PREFIX + this.producerCounter.getAndIncrement();
        if (description != null) {
            name = name + DESCRIPTION_SEPARATOR + description;
        }
        this.producers.add(name);
        return name;
    }

    @Override
    public void unregisterProducer(String name) {
        boolean ok = this.producers.remove(name);
        if (!ok) {
            throw new IllegalArgumentException("producer " + name + " not registered");
        }
    }

    @Override
    public String registerConsumer(String description) {
        String name = CONSUMER_NAME_PREFIX + this.consumerCounter.getAndIncrement();
        if (description != null) {
            name = name + DESCRIPTION_SEPARATOR + description;
        }
        this.consumers.add(name);
        return name;
    }

    @Override
    public void unregisterConsumer(String name) {
        boolean ok = this.consumers.remove(name);
        if (!ok) {
            throw new IllegalArgumentException("consumer " + name + " not registered");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HussarMQMemoryQueue{key='").append(this.key).append('\'');
        builder.append(", size=").append(this.queue.size());
        if (this.capacity > 0) {
            builder.append(", capacity=").append(this.capacity);
        }
        if (!this.producers.isEmpty()) {
            builder.append(", producers=").append(this.producers);
        }
        if (!this.consumers.isEmpty()) {
            builder.append(", consumers=").append(this.consumers);
        }
        builder.append('}');
        return builder.toString();
    }

    public static class Message {
        private final String producer;
        private final byte[] data;

        public Message(@NonNull String producer, @NonNull byte[] data) {
            this.producer = producer;
            this.data = data;
        }

        public String getProducer() {
            return this.producer;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return "Message{producer='" + this.producer + "', data=(" + this.data.length + " bytes)}";
        }
    }
}

