/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.standalone.producer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQLifecycleManager;
import com.jxdinfo.hussar.support.mq.producer.HussarMQAbstractProducer;
import com.jxdinfo.hussar.support.mq.standalone.queue.HussarMQStandaloneQueue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class HussarStandaloneMQProducer<T>
extends HussarMQAbstractProducer<T> {
    private static final Logger logger = LoggerFactory.getLogger(HussarStandaloneMQProducer.class);
    private final ObjectMapper objectMapper;
    private final HussarMQStandaloneQueue queue;
    private final String key;
    private final String description;
    private volatile String name;

    public HussarStandaloneMQProducer(HussarMQLifecycleManager lifecycleManager, @NonNull ObjectMapper objectMapper, @NonNull HussarMQStandaloneQueue queue, @NonNull String key, String description) {
        super(lifecycleManager);
        this.objectMapper = objectMapper;
        this.queue = queue;
        this.key = key;
        this.description = description;
    }

    protected void doStart() {
        logger.debug("Start standalone-mq producer {}", (Object)this.key);
        this.name = this.queue.registerProducer(this.description);
    }

    protected void doStop() {
        logger.debug("Stop standalone-mq producer {}/{}", (Object)this.key, (Object)this.name);
        this.queue.unregisterProducer(this.name);
        this.name = null;
    }

    public void postMessage(T message) {
        this.assertRunning();
        this.doPostMessage(message);
    }

    public void postMessageList(List<T> messages) {
        this.assertRunning();
        for (T message : messages) {
            this.doPostMessage(message);
        }
    }

    private void doPostMessage(T message) {
        logger.debug("Serialize and post message to {}/{}: {}", new Object[]{this.key, this.name, message});
        byte[] data = this.rawMessage(message);
        this.queue.offer(this.name, data);
    }

    private byte[] rawMessage(T message) {
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("failed to serialize message", ex);
        }
    }

    public String toString() {
        return "HussarStandaloneMQProducer<" + this.getLifecycleStateName() + " @" + this.key + "/" + this.name + ">";
    }
}

