/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.utils;

import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StreamOperations;

public abstract class HussarRedisMQUtils {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedisMQUtils.class);
    private static final ReadOffset STREAM_OFFSET_START = ReadOffset.from((String)"0");
    private static final String LETTUCE_PACKAGE_PREFIX = "io.lettuce.";
    private static final String JEDIS_PACKAGE_PREFIX = "redis.clients.jedis.";
    private static final String REDIS_ERROR_NO_GROUP_PREFIX = "NOGROUP ";
    private static final String REDIS_ERROR_BUSY_GROUP_PREFIX = "BUSYGROUP ";

    public static void createStreamIfAbsent(RedisTemplate<String, Object> redisTemplate, String streamName) {
        DataType type = redisTemplate.type((Object)streamName);
        switch (type) {
            case NONE: 
            case STREAM: {
                break;
            }
            default: {
                throw new IllegalStateException("non-stream key '" + streamName + "' already exists: " + type);
            }
        }
    }

    public static void createStreamGroupIfAbsent(RedisTemplate<String, Object> redisTemplate, String streamName, String groupName) {
        StreamOperations streamOps = redisTemplate.opsForStream();
        DataType type = redisTemplate.type((Object)streamName);
        switch (type) {
            case NONE: {
                HussarRedisMQUtils.doCreateStreamGroup((StreamOperations<String, String, Object>)streamOps, streamName, groupName);
                break;
            }
            case STREAM: {
                StreamInfo.XInfoGroups groups = streamOps.groups((Object)streamName);
                if (!groups.stream().noneMatch(group -> Objects.equals(group.groupName(), groupName))) break;
                HussarRedisMQUtils.doCreateStreamGroup((StreamOperations<String, String, Object>)streamOps, streamName, groupName);
                break;
            }
            default: {
                throw new IllegalStateException("non-stream key '" + streamName + "' already exists: " + type);
            }
        }
    }

    private static void doCreateStreamGroup(StreamOperations<String, String, Object> streamOps, String streamName, String groupName) {
        try {
            streamOps.createGroup((Object)streamName, STREAM_OFFSET_START, groupName);
        }
        catch (DataAccessException ex) {
            if (HussarRedisMQUtils.isRedisBusyGroup(ex)) {
                return;
            }
            throw ex;
        }
    }

    public static boolean isRedisNoGroup(Throwable throwable) {
        Throwable cause = HussarRedisMQUtils.getRootRedisException(throwable);
        return cause != null && StringUtils.startsWith((CharSequence)cause.getMessage(), (CharSequence)REDIS_ERROR_NO_GROUP_PREFIX);
    }

    public static boolean isRedisBusyGroup(Throwable throwable) {
        Throwable cause = HussarRedisMQUtils.getRootRedisException(throwable);
        return cause != null && StringUtils.startsWith((CharSequence)cause.getMessage(), (CharSequence)REDIS_ERROR_BUSY_GROUP_PREFIX);
    }

    public static Throwable getRootRedisException(Throwable throwable) {
        List chain = ExceptionUtils.getThrowableList((Throwable)throwable);
        Collections.reverse(chain);
        for (Throwable cause : chain) {
            if (!StringUtils.startsWithAny((CharSequence)cause.getClass().getName(), (CharSequence[])new CharSequence[]{LETTUCE_PACKAGE_PREFIX, JEDIS_PACKAGE_PREFIX})) continue;
            return cause;
        }
        return null;
    }

    public static String getClientType(RedisTemplate<String, Object> redisTemplate) {
        try {
            RedisConnectionFactory connectionFactory = redisTemplate.getRequiredConnectionFactory();
            Object nativeConnection = connectionFactory.getConnection().getNativeConnection();
            String nativeConnectionClass = nativeConnection.getClass().getName();
            if (nativeConnectionClass.startsWith(LETTUCE_PACKAGE_PREFIX)) {
                return "lettuce";
            }
            if (nativeConnectionClass.startsWith(JEDIS_PACKAGE_PREFIX)) {
                return "jedis";
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to infer redis client type", (Throwable)ex);
        }
        return null;
    }

    public static String generateStreamName(String prefix, String namespace, String key) {
        return prefix + ":" + namespace + ":" + key;
    }

    public static String generateRandomConsumerName(Sequence sequence) {
        if (sequence != null) {
            return "c-" + sequence.nextValue();
        }
        return "c-" + Hex.encodeHexString((byte[])HussarRedisMQUtils.generateUUIDv7());
    }

    private static byte[] generateUUIDv7() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        long timestamp = Instant.now().toEpochMilli();
        bytes[0] = (byte)(timestamp >> 40 & 0xFFL);
        bytes[1] = (byte)(timestamp >> 32 & 0xFFL);
        bytes[2] = (byte)(timestamp >> 24 & 0xFFL);
        bytes[3] = (byte)(timestamp >> 16 & 0xFFL);
        bytes[4] = (byte)(timestamp >> 8 & 0xFFL);
        bytes[5] = (byte)(timestamp & 0xFFL);
        bytes[6] = (byte)(0xF & bytes[6] | 0x70);
        bytes[8] = (byte)(0x3F & bytes[8] | 0x80);
        return bytes;
    }

    public static byte[] lz4Compress(byte[] original) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (LZ4FrameOutputStream lz4 = new LZ4FrameOutputStream((OutputStream)output);){
            lz4.write(original);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return output.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] lz4Decompress(byte[] compressed) {
        ByteArrayInputStream input = new ByteArrayInputStream(compressed);
        try (LZ4FrameInputStream lz4 = new LZ4FrameInputStream((InputStream)input);){
            byte[] byArray = IOUtils.toByteArray((InputStream)lz4);
            return byArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

