/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.consumer;

import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQAbstractConsumerBuilder;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQConsumer;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQLifecycleManager;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.consumer.HussarRedisMQConsumer;
import com.jxdinfo.hussar.support.mq.redis.message.HussarRedisMQMessageCodec;
import com.jxdinfo.hussar.support.mq.redis.utils.HussarRedisMQUtils;
import java.util.concurrent.ExecutorService;
import org.springframework.data.redis.core.RedisTemplate;

public class HussarRedisMQConsumerBuilder<T>
extends HussarMQAbstractConsumerBuilder<T> {
    private final HussarRedisMQProperties properties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final HussarRedisMQMessageCodec messageCodec;
    private final ExecutorService executorService;
    private final Sequence sequence;
    private final String streamName;
    private final String key;

    public HussarRedisMQConsumerBuilder(HussarMQLifecycleManager lifecycleManager, HussarRedisMQProperties properties, RedisTemplate<String, Object> redisTemplate, HussarRedisMQMessageCodec messageCodec, ExecutorService executorService, Sequence sequence, String streamName, String key) {
        super(lifecycleManager);
        this.properties = properties;
        this.redisTemplate = redisTemplate;
        this.messageCodec = messageCodec;
        this.executorService = executorService;
        this.sequence = sequence;
        this.streamName = streamName;
        this.key = key;
    }

    public HussarMQConsumer<T> doBuild(HussarMQLifecycleManager lifecycleManager) {
        if (this.properties == null) {
            throw new IllegalArgumentException("properties is required");
        }
        if (this.redisTemplate == null) {
            throw new IllegalArgumentException("redisTemplate is required");
        }
        if (this.messageCodec == null) {
            throw new IllegalArgumentException("messageCodec is required");
        }
        if (this.executorService == null) {
            throw new IllegalArgumentException("executorService is required");
        }
        if (this.streamName == null || this.key == null) {
            throw new IllegalArgumentException("streamName and key is required");
        }
        if ("-single-".equals(this.group)) {
            throw new IllegalArgumentException("reserved group name: " + this.group);
        }
        boolean singleGroup = this.group == null;
        String groupName = this.group != null ? this.group : "-single-";
        String consumerName = HussarRedisMQUtils.generateRandomConsumerName(this.sequence);
        return new HussarRedisMQConsumer(lifecycleManager, this.properties, this.redisTemplate, this.messageCodec, this.executorService, this.messageType, this.listener, this.key, this.streamName, groupName, consumerName, singleGroup);
    }
}

