/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.message;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.utils.HussarRedisMQUtils;
import com.jxdinfo.hussar.support.mq.shared.HussarMQObjectMapper;
import java.lang.reflect.Type;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class HussarRedisMQMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedisMQMessageCodec.class);
    private final HussarRedisMQProperties properties;
    private final ObjectMapper objectMapper;
    private final StringRedisSerializer keySerializer;
    private final GenericJackson2JsonRedisSerializer valueSerializer;

    public HussarRedisMQMessageCodec(HussarRedisMQProperties properties) {
        this(properties, (ObjectMapper)new HussarMQObjectMapper());
    }

    public HussarRedisMQMessageCodec(HussarRedisMQProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.keySerializer = new StringRedisSerializer();
        this.valueSerializer = new GenericJackson2JsonRedisSerializer(objectMapper);
    }

    public <K, V> void configureRedisTemplate(@NonNull RedisTemplate<K, V> redisTemplate) {
        redisTemplate.setKeySerializer((RedisSerializer)this.keySerializer);
        redisTemplate.setValueSerializer((RedisSerializer)this.valueSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)this.keySerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)this.valueSerializer);
    }

    @Nullable
    public String getSuggestedEncoding(@NonNull byte[] data, @Nullable String encoding) {
        if (encoding != null) {
            logger.debug("User prefer to use message encoding {} for data ({} bytes)...", (Object)encoding, (Object)data.length);
            if (encoding.equalsIgnoreCase("lz4")) {
                return "lz4";
            }
            throw new IllegalArgumentException("unsupported message encoding: " + encoding);
        }
        if (!this.properties.isAutoCompress()) {
            return null;
        }
        logger.debug("Detecting suggested message encoding for data ({} bytes)...", (Object)data.length);
        Long threshold = Optional.ofNullable(this.properties.getCompressThreshold()).map(DataSize::toBytes).orElse(null);
        if (threshold != null && (long)data.length < threshold) {
            logger.debug("Suggested no message encoding for data ({} bytes)", (Object)data.length);
            return null;
        }
        logger.debug("Suggested {} message encoding for data ({} bytes)", (Object)"lz4", (Object)data.length);
        return "lz4";
    }

    public byte[] encodeData(byte[] data, String encoding) {
        if (encoding == null) {
            return data;
        }
        if (!"lz4".equalsIgnoreCase(encoding)) {
            throw new IllegalArgumentException("unsupported message encoding: " + encoding);
        }
        byte[] encoded = HussarRedisMQUtils.lz4Compress(data);
        if (logger.isDebugEnabled()) {
            logger.debug("Encoded data using {}: encoded {} bytes / raw {} bytes = compress ratio {}%", new Object[]{encoding, encoded.length, data.length, String.format("%.2f", (double)encoded.length / (double)data.length * 100.0)});
        }
        return encoded;
    }

    public byte[] decodeData(byte[] data, String encoding) {
        if (encoding == null) {
            return data;
        }
        if (!"lz4".equals(encoding)) {
            throw new IllegalArgumentException("unsupported message encoding: " + encoding);
        }
        byte[] decoded = HussarRedisMQUtils.lz4Decompress(data);
        if (logger.isDebugEnabled()) {
            logger.debug("Decoded data using {}: decoded {} bytes / raw {} bytes = decompress ratio {}%", new Object[]{encoding, decoded.length, data.length, String.format("%.2f", (double)decoded.length / (double)data.length * 100.0)});
        }
        return decoded;
    }

    public byte[] toRawKey(@Nullable String key) {
        return this.keySerializer.serialize(key);
    }

    public String fromRawKey(@Nullable byte[] rawKey) {
        return this.keySerializer.deserialize(rawKey);
    }

    public byte[] toRawValue(@Nullable Object value) {
        return this.valueSerializer.serialize(value);
    }

    public Object fromRawValue(@Nullable byte[] rawValue) {
        return this.valueSerializer.deserialize(rawValue);
    }

    public <T> T fromRawValue(@Nullable byte[] rawValue, @NonNull Class<T> type) {
        return (T)this.valueSerializer.deserialize(rawValue, type);
    }

    public <T> T fromRawValue(@Nullable byte[] rawValue, @NonNull Type type) {
        Assert.notNull((Object)type, (String)"Deserialization type must not be null!");
        if (rawValue == null || rawValue.length == 0) {
            return null;
        }
        try {
            JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
            return (T)this.objectMapper.readValue(rawValue, javaType);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

