/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.producer;

import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQLifecycleManager;
import com.jxdinfo.hussar.support.mq.producer.HussarMQAbstractProducerBuilder;
import com.jxdinfo.hussar.support.mq.producer.HussarMQProducer;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.message.HussarRedisMQMessageCodec;
import com.jxdinfo.hussar.support.mq.redis.producer.HussarRedisMQProducer;
import org.springframework.data.redis.core.RedisTemplate;

public class HussarRedisMQProducerBuilder<T>
extends HussarMQAbstractProducerBuilder<T> {
    private final HussarRedisMQProperties properties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final HussarRedisMQMessageCodec messageCodec;
    private final String streamName;

    public HussarRedisMQProducerBuilder(HussarMQLifecycleManager lifecycleManager, HussarRedisMQProperties properties, RedisTemplate<String, Object> redisTemplate, HussarRedisMQMessageCodec messageCodec, String streamName) {
        super(lifecycleManager);
        this.properties = properties;
        this.redisTemplate = redisTemplate;
        this.messageCodec = messageCodec;
        this.streamName = streamName;
    }

    protected HussarMQProducer<T> doBuild(HussarMQLifecycleManager lifecycleManager) {
        if (this.properties == null) {
            throw new IllegalArgumentException("properties is required");
        }
        if (this.redisTemplate == null) {
            throw new IllegalArgumentException("redisTemplate is required");
        }
        if (this.messageCodec == null) {
            throw new IllegalArgumentException("messageCodec is required");
        }
        if (this.streamName == null) {
            throw new IllegalArgumentException("streamName is required");
        }
        return new HussarRedisMQProducer(lifecycleManager, this.properties, this.redisTemplate, this.messageCodec, this.streamName);
    }
}

