/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.languagedriver.sqlnode;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.regex.Pattern;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.scripting.ScriptingException;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.OgnlCache;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.type.SimpleTypeRegistry;

public class HussarTextNode
implements SqlNode {
    private final String text;
    private final Pattern injectionFilter;
    private static final String CUSTOM_SQL_SEGMENT = "#{ew.customSqlSegment}";
    private static final String SQL_SEGMENT = "#{ew.sqlSegment}";
    private static final String CUSTOM_SQL_SEGMENT_REPLACE = "${ew.customSqlSegment}";
    private static final String SQL_SEGMENT_REPLACE = "${ew.sqlSegment}";

    public HussarTextNode(String text) {
        this(text, null);
    }

    public HussarTextNode(String text, Pattern injectionFilter) {
        this.text = this.replaceCustomSqlSegment(text);
        this.injectionFilter = injectionFilter;
    }

    private String replaceCustomSqlSegment(String text) {
        if (HussarUtils.isEmpty((Object)text)) {
            return text;
        }
        if (text.contains(CUSTOM_SQL_SEGMENT)) {
            text = text.replace(CUSTOM_SQL_SEGMENT, CUSTOM_SQL_SEGMENT_REPLACE);
        }
        if (text.contains(SQL_SEGMENT)) {
            text = text.replace(SQL_SEGMENT, SQL_SEGMENT_REPLACE);
        }
        return text;
    }

    public boolean isDynamic() {
        DynamicCheckerTokenParser checker = new DynamicCheckerTokenParser();
        GenericTokenParser parser = this.createParser(checker);
        parser.parse(this.text);
        return checker.isDynamic();
    }

    public boolean apply(DynamicContext context) {
        GenericTokenParser parser = this.createParser(new BindingTokenParser(context, this.injectionFilter));
        context.appendSql(parser.parse(this.text));
        return true;
    }

    private GenericTokenParser createParser(TokenHandler handler) {
        return new GenericTokenParser("${", "}", handler);
    }

    private static class DynamicCheckerTokenParser
    implements TokenHandler {
        private boolean isDynamic;

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public String handleToken(String content) {
            this.isDynamic = true;
            return null;
        }
    }

    private static class BindingTokenParser
    implements TokenHandler {
        private DynamicContext context;
        private Pattern injectionFilter;

        public BindingTokenParser(DynamicContext context, Pattern injectionFilter) {
            this.context = context;
            this.injectionFilter = injectionFilter;
        }

        public String handleToken(String content) {
            Object parameter = this.context.getBindings().get("_parameter");
            if (parameter == null) {
                this.context.getBindings().put("value", null);
            } else if (SimpleTypeRegistry.isSimpleType(parameter.getClass())) {
                this.context.getBindings().put("value", parameter);
            }
            Object value = OgnlCache.getValue((String)content, (Object)this.context.getBindings());
            String srtValue = value == null ? "" : String.valueOf(value);
            this.checkInjection(srtValue);
            return srtValue;
        }

        private void checkInjection(String value) {
            if (this.injectionFilter != null && !this.injectionFilter.matcher(value).matches()) {
                throw new ScriptingException("Invalid input. Please conform to regex" + this.injectionFilter.pattern());
            }
        }
    }
}

