/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.languagedriver;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.apache.ibatis.builder.BuilderException;

public final class StaxServiceFinder {
    public static final String STAX_INPUT_FACTORY_WOODSTOX = "com.ctc.wstx.stax.WstxInputFactory";
    public static final String STAX_INPUT_FACTORY_AALTO = "com.fasterxml.aalto.stax.InputFactoryImpl";
    public static final String STAX_INPUT_FACTORY_JDK = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    public static final List<String> DEFAULT_PRIORITIES_STAX_INPUT_FACTORY = Collections.unmodifiableList(Arrays.asList("com.ctc.wstx.stax.WstxInputFactory", "com.fasterxml.aalto.stax.InputFactoryImpl", "com.sun.xml.internal.stream.XMLInputFactoryImpl"));

    public static XMLInputFactory createXMLInputFactory() {
        return StaxServiceFinder.createXMLInputFactory(DEFAULT_PRIORITIES_STAX_INPUT_FACTORY, true);
    }

    public static XMLInputFactory createXMLInputFactory(String preferred) {
        LinkedHashSet<String> distinctPriorities = new LinkedHashSet<String>();
        distinctPriorities.add(preferred);
        distinctPriorities.addAll(DEFAULT_PRIORITIES_STAX_INPUT_FACTORY);
        return StaxServiceFinder.createXMLInputFactory(new ArrayList<String>(distinctPriorities), true);
    }

    public static XMLInputFactory createXMLInputFactory(List<String> priorities, boolean spi) {
        if (priorities == null) {
            priorities = DEFAULT_PRIORITIES_STAX_INPUT_FACTORY;
        }
        try {
            for (String impl : priorities) {
                XMLInputFactory instance = StaxServiceFinder.tryCreateXMLInputFactory(impl);
                if (instance == null) continue;
                return instance;
            }
            if (spi) {
                return XMLInputFactory.newInstance();
            }
        }
        catch (Exception ex) {
            throw new BuilderException("failed to create XMLInputFactory", (Throwable)ex);
        }
        throw new BuilderException("no service available for XMLInputFactory");
    }

    private static XMLInputFactory tryCreateXMLInputFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (XMLInputFactory.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                return (XMLInputFactory)constructor.newInstance(new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

