/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.generator.superquery;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionSuperQueryColumnService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableColumnsInfo;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.mp.base.query.enums.PropertyTypeEnum;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.jxdinfo.hussar.support.mp.exception.MpRuntimeException;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperQueryGenerator<T> {
    private static final Logger log = LoggerFactory.getLogger(SuperQueryGenerator.class);
    Class<T> entityClass;

    public SuperQueryGenerator(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public <T> void initSuperQueryWrapper(QueryWrapper<T> queryWrapper, List<SuperQueryConditionDto> superQueryConditionDtos) {
        if (HussarUtils.isEmpty(queryWrapper)) {
            throw new MpRuntimeException("queywrapper \u4e3a\u7a7a\u65e0\u6cd5\u8fdb\u884c\u67e5\u8be2");
        }
        if (HussarUtils.isNotEmpty(superQueryConditionDtos)) {
            superQueryConditionDtos = this.filterRecursive(superQueryConditionDtos, sqcdl -> HussarUtils.isEmpty(sqcdl.getChildren()) && HussarUtils.isEmpty((Object)sqcdl.getField()));
            this.recursionQueryWrapper(queryWrapper, superQueryConditionDtos);
        }
    }

    public <T> void initSuperQueryOrderWrapper(QueryWrapper<T> queryWrapper, List<SuperQueryConditionDto> superQueryConditionDtoList, List<OrderItem> orderItems) {
        if (HussarUtils.isEmpty(queryWrapper)) {
            throw new MpRuntimeException("queryWrapper\u4e3a\u7a7a\u65e0\u6cd5\u8fdb\u884c\u67e5\u8be2");
        }
        if (HussarUtils.isNotEmpty(superQueryConditionDtoList)) {
            this.recursionQueryWrapper(queryWrapper, superQueryConditionDtoList);
        }
        this.dealOrderWrapper(queryWrapper, orderItems);
    }

    protected <T> void recursionQueryWrapper(QueryWrapper<T> queryWrapper, List<SuperQueryConditionDto> superQueryConditionDtos) {
        SuperQueryConditionDto condition = null;
        for (int i = 0; i < superQueryConditionDtos.size(); ++i) {
            condition = superQueryConditionDtos.get(i);
            FieldMappingDto fieldMappingDto = this.createFieldMapping(condition, this.entityClass);
            if (HussarUtils.isEmpty((Object)fieldMappingDto) || HussarUtils.isEmpty(condition.getChildren()) && HussarUtils.isEmpty((Object)fieldMappingDto.getColumnName())) continue;
            SuperQueryConditionDto finalCondition = condition;
            if (HussarUtils.isNotEmpty(condition.getChildren())) {
                if (StringUtil.equalsIgnoreCase((CharSequence)this.getPreMatach(i, superQueryConditionDtos), (CharSequence)MatchTypeEnum.AND.getValue())) {
                    queryWrapper.and(resSubQueryWrapper -> this.recursionQueryWrapper((QueryWrapper<T>)resSubQueryWrapper, finalCondition.getChildren()));
                    continue;
                }
                queryWrapper.or(resSubQueryWrapper -> this.recursionQueryWrapper((QueryWrapper<T>)resSubQueryWrapper, finalCondition.getChildren()));
                continue;
            }
            if (HussarUtils.isEmpty((Object)fieldMappingDto.getColumnName())) continue;
            if (StringUtil.equalsIgnoreCase((CharSequence)this.getPreMatach(i, superQueryConditionDtos), (CharSequence)MatchTypeEnum.AND.getValue())) {
                queryWrapper.and(this.conditionsMatch(fieldMappingDto), subQueryWrapper -> fieldMappingDto.getRule().getQueryStrategy().joinQueryWrapper(subQueryWrapper, fieldMappingDto));
                continue;
            }
            queryWrapper.or(this.conditionsMatch(fieldMappingDto), subQueryWrapper -> fieldMappingDto.getRule().getQueryStrategy().joinQueryWrapper(subQueryWrapper, fieldMappingDto));
        }
    }

    private boolean conditionsMatch(FieldMappingDto fieldMappingDto) {
        if (HussarUtils.isEmpty((Object)fieldMappingDto)) {
            return false;
        }
        if (fieldMappingDto.getRule().getValue().equals(QueryRuleEnum.IS_NOT_NULL.getValue()) || fieldMappingDto.getRule().getValue().equals(QueryRuleEnum.IS_NULl.getValue())) {
            return true;
        }
        return HussarUtils.isNotEmpty((Object)fieldMappingDto.getFieldValue());
    }

    private FieldMappingDto createFieldMapping(SuperQueryConditionDto condition, Class<T> clz) {
        QueryRuleEnum rule;
        FieldMappingDto fieldMappingDto = new FieldMappingDto();
        String match = HussarUtils.isEmpty((Object)condition.getMatch()) ? MatchTypeEnum.AND.getValue() : condition.getMatch();
        condition.setMatch(match);
        QueryRuleEnum queryRuleEnum = rule = HussarUtils.isEmpty((Object)condition.getRule()) ? QueryRuleEnum.EQ : QueryRuleEnum.getByValue(condition.getRule());
        if (HussarUtils.isEmpty((Object)((Object)rule))) {
            throw new HussarException("\u4e0d\u652f\u6301\u67e5\u8be2\u65b9\u5f0f");
        }
        fieldMappingDto.setRule(rule);
        if (HussarUtils.isNotEmpty((Object)condition.getField())) {
            String columnName = MpUtils.getTableFieldName(clz, condition.getField());
            if (HussarUtils.isEmpty((Object)columnName)) {
                if (HussarUtils.isEmpty((Object)(fieldMappingDto = this.getExpansionSuperQueryFiledMapping(fieldMappingDto, clz, condition.getField())))) {
                    throw new HussarException("\u4e0d\u5b58\u5728\u5c5e\u6027\u4e3a\uff1a" + condition.getField() + "\u7684\u5b57\u6bb5");
                }
            } else {
                fieldMappingDto.setColumnName(columnName);
            }
            fieldMappingDto.setFieldName(condition.getField());
            if (HussarUtils.isEmpty((Object)fieldMappingDto.getFieldClassType())) {
                PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(clz, (String)condition.getField());
                if (HussarUtils.isEmpty((Object)propertyDescriptor)) {
                    throw new HussarException("\u5c5e\u6027\u4e3a\uff1a" + condition.getField() + ",class\u5c5e\u6027\u4e3a\u7a7a");
                }
                fieldMappingDto.setFieldClassType(propertyDescriptor.getPropertyType());
            }
            if (HussarUtils.isNotEmpty((Object)condition.getVal())) {
                fieldMappingDto.setFieldValue(condition.getVal());
                rule.getQueryStrategy().transFieldValue(fieldMappingDto);
            }
        }
        return fieldMappingDto;
    }

    private String getPreMatach(int index, List<SuperQueryConditionDto> superQueryConditionDtos) {
        if (index <= 0) {
            return MatchTypeEnum.AND.getValue();
        }
        SuperQueryConditionDto superQueryConditionDto = superQueryConditionDtos.get(index - 1);
        return superQueryConditionDto.getMatch();
    }

    private List<SuperQueryConditionDto> filterRecursive(List<SuperQueryConditionDto> superQueryConditionDtoList, Predicate<SuperQueryConditionDto> filter) {
        ArrayList<SuperQueryConditionDto> result = new ArrayList<SuperQueryConditionDto>();
        for (SuperQueryConditionDto node : superQueryConditionDtoList) {
            if (filter.test(node)) {
                if (!HussarUtils.isNotEmpty(node.getChildren())) continue;
                result.addAll(this.filterRecursive(node.getChildren(), filter));
                continue;
            }
            SuperQueryConditionDto newNode = new SuperQueryConditionDto();
            newNode.setField(node.getField());
            newNode.setVal(node.getVal());
            newNode.setRule(node.getRule());
            newNode.setMatch(node.getMatch());
            if (HussarUtils.isNotEmpty(node.getChildren())) {
                newNode.setChildren(this.filterRecursive(node.getChildren(), filter));
            }
            result.add(newNode);
        }
        return result;
    }

    private FieldMappingDto getExpansionSuperQueryFiledMapping(FieldMappingDto fieldMappingDto, Class clz, String propertyName) {
        ExpansionSuperQueryColumnService expansionSuperQueryColumnService = (ExpansionSuperQueryColumnService)SpringContextUtil.getBean(ExpansionSuperQueryColumnService.class);
        if (HussarUtils.isEmpty((Object)expansionSuperQueryColumnService)) {
            return null;
        }
        String modelId = ExpansionContextHolder.get();
        ExpansionTableColumnsInfo expansionTableColumnInfo = expansionSuperQueryColumnService.getSuperQueryColumnService(modelId, clz, propertyName);
        if (HussarUtils.isEmpty((Object)expansionTableColumnInfo)) {
            return null;
        }
        String columnName = expansionTableColumnInfo.getColumnName();
        if (expansionTableColumnInfo.isEnableAlias() && HussarUtils.isNotEmpty((Object)expansionTableColumnInfo.getAlias())) {
            columnName = expansionTableColumnInfo.getAlias() + "." + columnName;
        }
        fieldMappingDto.setColumnName(columnName);
        fieldMappingDto.setFieldClassType(this.getClassType(expansionTableColumnInfo.getPropertyType()));
        return fieldMappingDto;
    }

    protected <T> void dealOrderWrapper(QueryWrapper<T> queryWrapper, List<OrderItem> orderItems) {
        if (HussarUtils.isEmpty(orderItems)) {
            return;
        }
        for (OrderItem orderItem : orderItems) {
            FieldMappingDto fieldMappingDto = this.createFieldMapping(orderItem.getColumn(), this.entityClass);
            if (HussarUtils.isEmpty((Object)fieldMappingDto)) continue;
            if (orderItem.isAsc()) {
                queryWrapper.orderByAsc((Object)fieldMappingDto.getColumnName());
                continue;
            }
            queryWrapper.orderByDesc((Object)fieldMappingDto.getColumnName());
        }
    }

    private FieldMappingDto createFieldMapping(String fieldName, Class<T> clz) {
        if (HussarUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        FieldMappingDto fieldMappingDto = new FieldMappingDto();
        fieldMappingDto.setFieldName(fieldName);
        return this.getExpansionSuperQueryFiledMapping(fieldMappingDto, clz, fieldName);
    }

    private Class<?> getClassType(String type) {
        return PropertyTypeEnum.getClassType(type);
    }
}

