/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.generator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SqlInjectionUtil;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.jxdinfo.hussar.support.mp.base.query.generator.QueryGenerator;
import com.jxdinfo.hussar.support.mp.exception.MpRuntimeException;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTableQueryGenerator
extends QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(SingleTableQueryGenerator.class);
    private static final List<String> filterFieldList = new ArrayList<String>();

    @Override
    protected List<FieldMappingDto> createQueryWrapper(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        Class<?> objectClass = searchObj.getClass();
        PropertyDescriptor[] origDescriptors = HussarUtils.getPropertyDescriptors(objectClass);
        ArrayList<FieldMappingDto> fieldMappingDtoList = new ArrayList<FieldMappingDto>();
        for (PropertyDescriptor origDescriptor : origDescriptors) {
            String name = origDescriptor.getName();
            Class<?> type = origDescriptor.getPropertyType();
            try {
                if (this.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                String column = MpUtils.getTableFieldName(searchObj.getClass(), name);
                if (HussarUtils.isBlank((CharSequence)column)) continue;
                FieldMappingDto fieldMappingDto = new FieldMappingDto(name, column, type);
                fieldMappingDtoList.add(fieldMappingDto);
                SingleTableQueryGenerator.doJoinQuery(queryWrapper, parameterMap, fieldMappingDto, value);
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5:{} \u62fc\u63a5\u67e5\u8be2\u6784\u9020\u5668\u5f02\u5e38\uff1a{}", (Object)name, (Object)e.getMessage());
                throw new MpRuntimeException(e);
            }
        }
        return fieldMappingDtoList;
    }

    private static void doJoinQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, FieldMappingDto fieldMappingDto, Object value) throws ParseException {
        if (HussarUtils.isNotEmpty((Object)value)) {
            fieldMappingDto.setFieldValue(value);
            fieldMappingDto.setRule(QueryRuleEnum.EQ);
            fieldMappingDto = QueryRuleEnum.EQ.getQueryStrategy().transFieldValue(fieldMappingDto);
            QueryRuleEnum.EQ.getQueryStrategy().joinQueryWrapper(queryWrapper, fieldMappingDto);
            return;
        }
        if (HussarUtils.isNotEmpty(parameterMap)) {
            for (QueryRuleEnum queryRuleEnum : QueryRuleEnum.values()) {
                String paramKey = fieldMappingDto.getFieldName().concat(queryRuleEnum.getValue());
                if (!parameterMap.containsKey(paramKey)) continue;
                String[] values = parameterMap.get(paramKey);
                Object paramValue = values.length == 1 ? values[0] : Arrays.asList(values);
                fieldMappingDto.setFieldValue(paramValue);
                fieldMappingDto.setRule(queryRuleEnum);
                fieldMappingDto = queryRuleEnum.getQueryStrategy().transFieldValue(fieldMappingDto);
                queryRuleEnum.getQueryStrategy().joinQueryWrapper(queryWrapper, fieldMappingDto);
            }
        }
    }

    @Override
    protected void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        String[] orderColumns;
        String orderRule = null;
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("orderRule")) {
            orderRule = parameterMap.get("orderRule")[0];
        }
        String defaultOrderRule = null;
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("defaultOrderRule")) {
            defaultOrderRule = parameterMap.get("defaultOrderRule")[0];
        }
        HashSet<String> orderRuleColumns = new HashSet<String>();
        if (HussarUtils.isNotEmpty((Object)orderRule)) {
            for (String rule : orderColumns = orderRule.split(";")) {
                this.dealOrder(rule, searchObj, orderRuleColumns, queryWrapper);
            }
        }
        if (HussarUtils.isNotEmpty(defaultOrderRule)) {
            for (String rule : orderColumns = defaultOrderRule.split(";")) {
                this.dealOrder(rule, searchObj, orderRuleColumns, queryWrapper);
            }
        }
    }

    @Override
    protected void doMultiFieldsGroup(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        String groupRule = null;
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("groupRule")) {
            groupRule = parameterMap.get("groupRule")[0];
        }
        HashSet<String> groupRuleColumns = new HashSet<String>();
        if (HussarUtils.isNotEmpty(groupRule)) {
            String[] groupColumns;
            for (String rule : groupColumns = groupRule.split(",")) {
                this.dealGroup(rule, searchObj, groupRuleColumns, queryWrapper);
            }
        }
    }

    @Override
    protected void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, List<FieldMappingDto> fieldMappingDtoList) {
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("superQueryParams")) {
            String[] superQueryParams = parameterMap.get("superQueryParams");
            String superQueryMatchType = parameterMap.get("superQueryMatchType") != null ? parameterMap.get("superQueryMatchType")[0] : MatchTypeEnum.AND.getValue();
            MatchTypeEnum matchType = MatchTypeEnum.getByValue(superQueryMatchType.toUpperCase());
            for (String superQueryParam : superQueryParams) {
                try {
                    superQueryParam = URLDecoder.decode(superQueryParam, "UTF-8");
                    List conditions = JsonUtil.readList((String)superQueryParam, QueryConditionDto.class);
                    if (HussarUtils.isEmpty((Object)conditions)) {
                        return;
                    }
                    log.debug("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + conditions);
                    if (MatchTypeEnum.OR.equals((Object)matchType)) {
                        queryWrapper.or(wrapper -> this.packageSuperQuery(conditions, (QueryWrapper<?>)wrapper, fieldMappingDtoList));
                        continue;
                    }
                    queryWrapper.and(wrapper -> this.packageSuperQuery(conditions, (QueryWrapper<?>)wrapper, fieldMappingDtoList));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25\uff1a" + superQueryParam, (Throwable)e);
                }
                catch (Exception e) {
                    log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a" + e.getMessage());
                    throw new MpRuntimeException(e);
                }
            }
        }
        log.debug(" superQuery getCustomSqlSegment: " + queryWrapper.getCustomSqlSegment());
    }

    @Override
    protected void doSuperQueryRes(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap) {
        if (HussarUtils.isEmpty(parameterMap)) {
            return;
        }
        Object[] superQueryConditions = parameterMap.get("superQueryCondition");
        if (HussarUtils.isEmpty((Object[])superQueryConditions) || superQueryConditions.length <= 0 || superQueryConditions.length > 1) {
            return;
        }
        List superQueryConditionDtos = JsonUtil.readList((String)superQueryConditions[0], SuperQueryConditionDto.class);
    }

    private static FieldMappingDto findListByField(List<FieldMappingDto> fieldMappingDtoList, String fieldName) {
        return fieldMappingDtoList.stream().filter(fieldMappingDto -> fieldMappingDto.getFieldName().equalsIgnoreCase(fieldName)).findFirst().orElse(null);
    }

    @Override
    protected boolean judgedIsUselessField(String fieldName) {
        return filterFieldList.contains(fieldName);
    }

    private void dealOrder(String rule, Object searchObj, Set<String> orderRuleColumns, QueryWrapper<?> queryWrapper) {
        if (HussarUtils.isBlank((CharSequence)rule)) {
            return;
        }
        String[] order = rule.trim().split(",");
        String column = MpUtils.getTableFieldName(searchObj.getClass(), order[0].trim());
        if (HussarUtils.isBlank((CharSequence)column) || orderRuleColumns.contains(column)) {
            return;
        }
        SqlInjectionUtil.filterContent((String)column);
        String orderType = order.length > 1 ? order[1].trim() : "ASC";
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + orderType);
        if ("ASC".equalsIgnoreCase(orderType)) {
            queryWrapper.orderByAsc((Object)column);
        } else {
            queryWrapper.orderByDesc((Object)column);
        }
        orderRuleColumns.add(column);
    }

    private void dealGroup(String rule, Object searchObj, Set<String> orderRuleColumns, QueryWrapper<?> queryWrapper) {
        if (HussarUtils.isBlank((CharSequence)rule)) {
            return;
        }
        String group = rule.trim();
        String column = MpUtils.getTableFieldName(searchObj.getClass(), group.trim());
        if (HussarUtils.isBlank((CharSequence)column) || orderRuleColumns.contains(column)) {
            return;
        }
        SqlInjectionUtil.filterContent((String)column);
        log.debug("\u5206\u7ec4\u89c4\u5219>>\u5217:" + column);
        queryWrapper.groupBy((Object)column);
        orderRuleColumns.add(column);
    }

    private void packageSuperQuery(List<QueryConditionDto> conditions, QueryWrapper<?> wrapper, List<FieldMappingDto> fieldMappingDtoList) {
        for (int i = 0; i < conditions.size(); ++i) {
            MatchTypeEnum paramMatch;
            QueryConditionDto rule = conditions.get(i);
            if (!HussarUtils.isNotEmpty((Object)rule.getField()) || !HussarUtils.isNotEmpty((Object)rule.getRule()) || !HussarUtils.isNotEmpty((Object)rule.getVal())) continue;
            log.debug("SuperQuery ==> " + rule);
            FieldMappingDto fieldMappingDto = SingleTableQueryGenerator.findListByField(fieldMappingDtoList, rule.getField());
            fieldMappingDto.setFieldValue(rule.getVal());
            fieldMappingDto.setRule(QueryRuleEnum.getByValue(rule.getRule()));
            fieldMappingDto.getRule().getQueryStrategy().transFieldValue(fieldMappingDto);
            fieldMappingDto.getRule().getQueryStrategy().joinQueryWrapper(wrapper, fieldMappingDto);
            MatchTypeEnum matchTypeEnum = paramMatch = HussarUtils.isEmpty((Object)rule.getMatch()) ? MatchTypeEnum.AND : MatchTypeEnum.getByValue(rule.getMatch().toUpperCase());
            if (!MatchTypeEnum.OR.equals((Object)paramMatch) || i >= conditions.size() - 1) continue;
            wrapper.or();
        }
    }

    static {
        filterFieldList.add("class");
        filterFieldList.add("ids");
        filterFieldList.add("page");
        filterFieldList.add("rows");
        filterFieldList.add("sort");
        filterFieldList.add("order");
    }
}

