/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.enums;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum PropertyTypeEnum {
    STRING("string", String.class),
    BYTE("byte", Byte.class),
    CHAR("char", Character.class),
    CHARACTER("character", Character.class),
    LONG("long", Long.class),
    SHORT("short", Short.class),
    INT("int", Integer.class),
    INTEGER("integer", Integer.class),
    DOUBLE("double", Double.class),
    FLOAT("float", Float.class),
    BOOLEAN("boolean", Boolean.class),
    BYTE_ARRAY("byte[]", Byte[].class),
    CHAR_ARRAY("char[]", Character[].class),
    CHARACTER_ARRAY("character[]", Character[].class),
    LONG_ARRAY("long[]", Long[].class),
    SHORT_ARRAY("short[]", Short[].class),
    INT_ARRAY("int[]", Integer[].class),
    INTEGER_ARRAY("integer[]", Integer[].class),
    DOUBLE_ARRAY("double[]", Double[].class),
    FLOAT_ARRAY("float[]", Float[].class),
    BOOLEAN_ARRAY("boolean[]", Boolean[].class),
    _BYTE("_byte", Byte.TYPE),
    _CHAR("_char", Character.TYPE),
    _CHARACTER("_character", Character.TYPE),
    _LONG("_long", Long.TYPE),
    _SHORT("_short", Short.TYPE),
    _INT("_int", Integer.TYPE),
    _INTEGER("_integer", Integer.TYPE),
    _DOUBLE("_double", Double.TYPE),
    _FLOAT("_float", Float.TYPE),
    _BOOLEAN("_boolean", Boolean.TYPE),
    _BYTE_ARRAY("_byte[]", byte[].class),
    _CHAR_ARRAY("_char[]", char[].class),
    _CHARACTER_ARRAY("_character[]", char[].class),
    _LONG_ARRAY("_long[]", long[].class),
    _SHORT_ARRAY("_short[]", short[].class),
    _INT_ARRAY("_int[]", int[].class),
    _INTEGER_ARRAY("_integer[]", int[].class),
    _DOUBLE_ARRAY("_double[]", double[].class),
    _FLOAT_ARRAY("_float[]", float[].class),
    _BOOLEAN_ARRAY("_boolean[]", boolean[].class),
    DATE("date", Date.class),
    LOCALDATE("localdate", LocalDate.class),
    LOCALTIME("localtime", LocalTime.class),
    LOCALDATETIME("localdatetime", LocalDateTime.class),
    DECIMAL("decimal", BigDecimal.class),
    BIGDECIMAL("bigdecimal", BigDecimal.class),
    BIGINTEGER("biginteger", BigInteger.class),
    OBJECT("object", Object.class),
    DATE_ARRAY("date[]", Date[].class),
    DECIMAL_ARRAY("decimal[]", BigDecimal[].class),
    BIGDECIMAL_ARRAY("bigdecimal[]", BigDecimal[].class),
    BIGINTEGER_ARRAY("biginteger[]", BigInteger[].class),
    OBJECT_ARRAY("object[]", Object[].class),
    MAP("map", Map.class),
    HASHMAP("hashmap", HashMap.class),
    list("list", List.class),
    ARRAYLIST("arraylist", ArrayList.class),
    COLLECTION("collection", Collection.class),
    ITERATOR("iterator", Iterator.class),
    RESULTSET("ResultSet", ResultSet.class);

    private final String type;
    private final Class<?> classType;

    private PropertyTypeEnum(String type, Class<?> classType) {
        this.type = type;
        this.classType = classType;
    }

    public String getType() {
        return this.type;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public static Class<?> getClassType(String type) {
        if (HussarUtils.isBlank((CharSequence)type)) {
            return String.class;
        }
        String propertyType = type.toUpperCase(Locale.ENGLISH);
        try {
            PropertyTypeEnum propertyTypeEnum = PropertyTypeEnum.valueOf(propertyType);
            return propertyTypeEnum.getClassType();
        }
        catch (Exception e) {
            return String.class;
        }
    }
}

