/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.jxdinfo.hussar.platform.core.config.CoreConfiguration;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.IdStringCreator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MpMybatisPropertiesCustomizer;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.customizer.DataSchemaMybatisPlusInterceptorCustomizer;
import com.jxdinfo.hussar.support.mp.customizer.HussarPaginationInterceptorCustomizer;
import com.jxdinfo.hussar.support.mp.customizer.MybatisPlusInterceptorCustomizer;
import com.jxdinfo.hussar.support.mp.handler.DefaultHussarMetaObjectHandler;
import com.jxdinfo.hussar.support.mp.idgenerator.HussarIdGenerator;
import com.jxdinfo.hussar.support.mp.injector.HussarSqlInjector;
import com.jxdinfo.hussar.support.mp.intercept.QueryInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.SqlLogInterceptor;
import com.jxdinfo.hussar.support.mp.resolver.PageArgumentResolver;
import com.jxdinfo.hussar.support.mp.transaction.HussarMpTransactionFactory;
import com.jxdinfo.hussar.support.mp.translator.HussarMybatisExceptionTranslator;
import com.jxdinfo.hussar.support.sequence.config.HussarSequenceConfiguration;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CoreConfiguration.class, HussarSequenceConfiguration.class, MybatisPlusAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusAutoFillProperties.class, MybatisPlusPluginProperties.class})
public class MpConfiguration
implements WebMvcConfigurer {
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;
    private MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties;

    public MpConfiguration(MybatisPlusPluginProperties mybatisPlusPluginProperties, MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }

    public MpConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<List<MybatisPlusInterceptorCustomizer>> mybatisPlusInterceptorCustomizerObjectProvider) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        List mybatisPlusInterceptorCustomizerList = (List)mybatisPlusInterceptorCustomizerObjectProvider.getIfAvailable();
        if (HussarUtils.isNotEmpty((Object)mybatisPlusInterceptorCustomizerList)) {
            mybatisPlusInterceptorCustomizerList.stream().forEach(cust -> cust.customize(interceptor));
        }
        return interceptor;
    }

    @Bean
    @Order(value=30)
    @ConditionalOnProperty(prefix="hussar.mp.plugin", name={"schemaEnabled"}, havingValue="true", matchIfMissing=true)
    public MybatisPlusInterceptorCustomizer databaseSchemaMybatisPlusInterceptorCustomizer(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        return new DataSchemaMybatisPlusInterceptorCustomizer(mybatisPlusPluginProperties);
    }

    @Bean
    @Order(value=20)
    public MybatisPlusInterceptorCustomizer hussarPaginationInterceptorCustomizer(ObjectProvider<QueryInterceptor[]> queryInterceptors, MybatisPlusPluginProperties mybatisPlusProperties) {
        return new HussarPaginationInterceptorCustomizer(queryInterceptors, mybatisPlusProperties);
    }

    @Bean
    public ConfigurationCustomizer mpMybatisPropertiesCustomizer() {
        return new MpMybatisPropertiesCustomizer();
    }

    @Bean
    public SqlLogInterceptor sqlLogInterceptor(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        return new SqlLogInterceptor(mybatisPlusPluginProperties);
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return new HussarSqlInjector();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageArgumentResolver());
    }

    @Primary
    @Bean
    public IdentifierGenerator idGenerator(SeqBuilder seqBuilder) {
        Sequence sequence = seqBuilder.build();
        return new HussarIdGenerator(sequence);
    }

    @Bean
    public MetaObjectHandler metaObjectHandler(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties, @Autowired(required=false) GetLoginUserService getLoginUserService, @Autowired(required=false) IdStringCreator idStringCreator) {
        return new DefaultHussarMetaObjectHandler(mybatisPlusAutoFillProperties, getLoginUserService, idStringCreator);
    }

    @Bean
    @ConditionalOnBean(name={"hussarTransactionAdvisor"})
    public TransactionFactory transactionFactory() {
        return new HussarMpTransactionFactory();
    }

    @Bean
    @Primary
    public SqlSessionTemplate hussarSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, MybatisPlusProperties mybatisPlusProperties) {
        ExecutorType executorType = mybatisPlusProperties.getExecutorType();
        if (executorType == null) {
            executorType = sqlSessionFactory.getConfiguration().getDefaultExecutorType();
        }
        HussarMybatisExceptionTranslator persistenceExceptionTranslator = new HussarMybatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
        return new SqlSessionTemplate(sqlSessionFactory, executorType, (PersistenceExceptionTranslator)persistenceExceptionTranslator);
    }

    public MybatisPlusPluginProperties getMybatisPlusPluginProperties() {
        return this.mybatisPlusPluginProperties;
    }

    public void setMybatisPlusPluginProperties(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    public MybatisPlusAutoFillProperties getMybatisPlusAutoFillProperties() {
        return this.mybatisPlusAutoFillProperties;
    }

    public void setMybatisPlusAutoFillProperties(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }
}

