/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.encrypt.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.annotation.EncryptField;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class EncryptReadInterceptor
implements Interceptor {
    private static final String MAPPED_STATEMENT = "mappedStatement";
    private final Encrypt encrypt;

    public EncryptReadInterceptor(Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        ResultSetHandler resultSetHandler = (ResultSetHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)resultSetHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
        Map<String, EncryptField> encryptFieldMap = this.getEncryptByResultMap(resultMap);
        if (ObjectUtil.isEmpty(encryptFieldMap)) {
            return results;
        }
        for (Object obj : results) {
            MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
            for (Map.Entry<String, EncryptField> entry : encryptFieldMap.entrySet()) {
                String decryptValue;
                String property = entry.getKey();
                String value = (String)objMetaObject.getValue(property);
                if (!HussarUtils.isNotEmpty((Object)value)) continue;
                try {
                    decryptValue = this.encrypt.decrypt(value);
                }
                catch (Exception e) {
                    decryptValue = value;
                }
                objMetaObject.setValue(property, (Object)decryptValue);
            }
        }
        return results;
    }

    private Map<String, EncryptField> getEncryptByResultMap(ResultMap resultMap) {
        HashMap<String, EncryptField> encryptFieldHashMap = new HashMap<String, EncryptField>(16);
        if (HussarUtils.isEmpty((Object)resultMap)) {
            return encryptFieldHashMap;
        }
        Class clazz = resultMap.getType();
        for (Field field : clazz.getDeclaredFields()) {
            EncryptField encryptField = field.getAnnotation(EncryptField.class);
            if (!HussarUtils.isNotEmpty((Object)encryptField)) continue;
            encryptFieldHashMap.put(field.getName(), encryptField);
        }
        return encryptFieldHashMap;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

