/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.encrypt.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.config.EncryptProperties;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.interceptor.EncryptReadInterceptor;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.interceptor.EncryptWriteInterceptor;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.DefaultSM4Encrypt;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.RefreshDataHelper;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EncryptProperties.class})
@MapperScan(basePackages={"com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.mapper"})
@ConditionalOnProperty(prefix="hussar.mp.encrypt", name={"enable"}, havingValue="true", matchIfMissing=false)
public class EncryptConfiguration {
    public EncryptProperties encryptProperties;

    public EncryptConfiguration(EncryptProperties encryptProperties) {
        this.encryptProperties = encryptProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public Encrypt defaultSM4Encrypt(EncryptProperties encryptProperties) {
        return new DefaultSM4Encrypt(encryptProperties);
    }

    @Bean
    ConfigurationCustomizer configurationCustomizer(EncryptProperties encryptProperties) throws Exception {
        EncryptWriteInterceptor encryptWriteInterceptor = new EncryptWriteInterceptor(this.defaultSM4Encrypt(encryptProperties));
        EncryptReadInterceptor encryptReadInterceptor = new EncryptReadInterceptor(this.defaultSM4Encrypt(encryptProperties));
        return configuration -> {
            configuration.addInterceptor((Interceptor)encryptWriteInterceptor);
            configuration.addInterceptor((Interceptor)encryptReadInterceptor);
        };
    }

    @Bean
    RefreshDataHelper refreshDataHelper(EncryptProperties encryptProperties) {
        return new RefreshDataHelper(this.defaultSM4Encrypt(encryptProperties), encryptProperties);
    }
}

