/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.config.EncryptProperties;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.dto.RefreshDataDTO;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.dto.RefreshParamDTO;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.enums.CalculateType;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.refreshdata.mapper.RefreshDataMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;

public class RefreshDataHelper {
    private final Encrypt encrypt;
    @Resource
    private RefreshDataMapper refreshDataMapper;
    private final EncryptProperties encryptProperties;

    public RefreshDataHelper(Encrypt encrypt, EncryptProperties encryptProperties) {
        this.encrypt = encrypt;
        this.encryptProperties = encryptProperties;
    }

    @DSTransactional
    public void refreshPlaintextToCipher(RefreshParamDTO refreshParam) {
        List<Map<String, Object>> dataMapList;
        if (!this.encryptProperties.isEnableRefreshHistoryData()) {
            throw new HussarException("\u5237\u6570\u636e\u5f00\u5173\u672a\u5f00\u542f\uff01");
        }
        this.check(refreshParam);
        Long limit = 0L;
        Long offset = this.encryptProperties.getRefreshDataStep();
        do {
            dataMapList = this.refreshDataMapper.getDataByUniqueKey(refreshParam.getTableName(), refreshParam.getPrimaryKeys(), limit, offset);
            this.refreshData(refreshParam, dataMapList);
            limit = limit + offset;
        } while ((long)dataMapList.size() >= this.encryptProperties.getRefreshDataStep());
    }

    private void refreshData(RefreshParamDTO brushDataInfo, List<Map<String, Object>> dataMapList) {
        ArrayList refreshDataList = new ArrayList();
        dataMapList.forEach(dataMap -> {
            RefreshDataDTO refreshData = new RefreshDataDTO();
            brushDataInfo.getColumnNames().forEach(columnName -> {
                try {
                    String value = (String)dataMap.get(columnName);
                    if (HussarUtils.isNotEmpty((Object)value)) {
                        String encryptValue = this.encrypt.encrypt(value);
                        refreshData.getEncryptKeyMap().put((String)columnName, encryptValue);
                    }
                }
                catch (Exception e) {
                    throw new HussarException("\u6536\u96c6\u5f85\u52a0\u5bc6\u5b57\u6bb5\u540d\u548c\u52a0\u5bc6\u540e\u6570\u636e\u503c\u5931\u8d25", (Throwable)e);
                }
            });
            brushDataInfo.getPrimaryKeys().forEach(primaryKeyInfo -> {
                try {
                    String primaryKeyName = primaryKeyInfo.getPrimaryKeyName();
                    refreshData.getPrimaryKeyMap().put(primaryKeyName, dataMap.get(primaryKeyName));
                }
                catch (Exception e) {
                    throw new HussarException("\u6536\u96c6\u552f\u4e00\u952e\u5b57\u6bb5\u540d\u548c\u6570\u636e\u503c\u5931\u8d25", (Throwable)e);
                }
            });
            if (HussarUtils.isNotEmpty(refreshData.getEncryptKeyMap()) && HussarUtils.isNotEmpty(refreshData.getPrimaryKeyMap())) {
                refreshDataList.add(refreshData);
            }
        });
        refreshDataList.forEach(refreshDataDTO -> this.refreshDataMapper.updateData(brushDataInfo.getTableName(), (RefreshDataDTO)refreshDataDTO));
    }

    private void check(RefreshParamDTO refreshParam) {
        if (HussarUtils.isEmpty((Object)refreshParam) || HussarUtils.isBlank((CharSequence)refreshParam.getTableName()) || HussarUtils.isEmpty(refreshParam.getColumnNames())) {
            throw new HussarException("\u8868\u4e2d\u660e\u6587\u6570\u636e\u5237\u4e3a\u5bc6\u6587\u65f6\uff0c\u8868\u540d\u3001\u5f85\u5237\u6570\u636e\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isNotEmpty(refreshParam.getPrimaryKeys())) {
            refreshParam.getPrimaryKeys().forEach(primaryKeyDTO -> {
                if (HussarUtils.isEmpty((Object)primaryKeyDTO.getPrimaryKeyName()) || HussarUtils.isEmpty(primaryKeyDTO.getPrimaryKeyRanges())) {
                    throw new HussarException("\u4e3b\u952e\u6216\u552f\u4e00\u952ename\u3001\u53d6\u503c\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                primaryKeyDTO.getPrimaryKeyRanges().forEach(keyRange -> {
                    if (HussarUtils.isEmpty((Object)keyRange.getValue())) {
                        throw new HussarException("\u4e3b\u952e\u6216\u552f\u4e00\u952e\u53d6\u503c\u8303\u56f4\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    Optional<CalculateType> optional = Arrays.asList(CalculateType.values()).stream().filter(calculateType -> calculateType.operate.equals(keyRange.getOperate())).findFirst();
                    if (!optional.isPresent()) {
                        throw new HussarException("\u4e3b\u952e\u6216\u552f\u4e00\u952e\u53d6\u503c\u8303\u56f4\u8fd0\u7b97\u7b26operate\u9519\u8bef\uff0c\u4ec5\u80fd\u4e3a>\u3001>=\u3001<\u3001<=\u3001=");
                    }
                });
            });
        }
    }
}

