/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.encrypt.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.annotation.EncryptField;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="parameterize", args={Statement.class})})
public class EncryptWriteInterceptor
implements Interceptor {
    private Encrypt encrypt;
    private final String PARAMETER = "_parameter";

    public EncryptWriteInterceptor(Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        MappedStatement mappedStatement = mpStatementHandler.mappedStatement();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = mpStatementHandler.boundSql();
        Object parameterObject = boundSql.getParameterObject();
        boolean isEntity = false;
        if (parameterObject instanceof Map) {
            Object et = ((Map)parameterObject).getOrDefault("et", null);
            if (HussarUtils.isEmpty(et) || et instanceof Map) {
                return invocation.proceed();
            }
            parameterObject = et;
            isEntity = true;
        }
        this.handleParameters(mappedStatement.getConfiguration(), boundSql, parameterObject, sqlCommandType, isEntity);
        return invocation.proceed();
    }

    private void handleParameters(Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType, boolean isEntity) throws Exception {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        StringBuilder paramKeyBuilder = new StringBuilder();
        paramKeyBuilder.append("_parameter").append(".");
        if (isEntity) {
            paramKeyBuilder.append("et").append(".");
        }
        String paramKey = paramKeyBuilder.toString();
        if (HussarUtils.isEmpty((Object)param)) {
            return;
        }
        for (Field field : param.getClass().getDeclaredFields()) {
            Object value;
            EncryptField encryptField = field.getAnnotation(EncryptField.class);
            if (!HussarUtils.isNotEmpty((Object)encryptField)) continue;
            Object newValue = value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence) {
                newValue = this.handleEncryptField(field, newValue);
            }
            if (value == null || newValue == null || value.equals(newValue)) continue;
            newValues.put(field.getName(), newValue);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter(paramKey + (String)entry.getKey(), entry.getValue());
        }
    }

    private Object handleEncryptField(Field field, Object value) {
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        Object newValue = value;
        if (encryptField != null && value != null) {
            newValue = this.encrypt.encrypt(value.toString());
        }
        return newValue;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

