/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.config;

import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.support.redis.ClusterTypeEnum;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedissonProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarRedisLockConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.redisson.Redisson;
import org.redisson.api.NameMapper;
import org.redisson.api.RedissonClient;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={HussarRedissonProperties.class})
@ConditionalOnProperty(prefix="hussar.lock", value={"type"}, havingValue="redis")
public class HussarRedissonConfiguration
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedissonConfiguration.class);
    private ResourceLoader resourceLoader;

    @Bean
    public RedissonClient redisson(RedisProperties redisProperties, ObjectProvider<HussarCacheProperties> cacheProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties) {
        Optional<Object> cachePropertiesOptional = Optional.ofNullable(cacheProperties.getIfAvailable());
        String cacheType = cachePropertiesOptional.map(HussarCacheProperties::getCacheType).orElse(null);
        String clusterType = cachePropertiesOptional.map(HussarCacheProperties::getRedisCluster).orElse(null);
        if (!"redis".equals(cacheType)) {
            clusterType = null;
        }
        Config config = ClusterTypeEnum.CLUSTER.getKey().equalsIgnoreCase(clusterType) ? this.getClusterConfig(redisProperties, redisLockProperties, redissonProperties) : (ClusterTypeEnum.SENTINEL.getKey().equalsIgnoreCase(clusterType) ? this.getSentinelConfig(redisProperties, redisLockProperties, redissonProperties) : (ClusterTypeEnum.STANDALONE.getKey().equalsIgnoreCase(clusterType) ? this.getSingleConfig(redisProperties, redisLockProperties, redissonProperties) : (redisProperties.getSentinel() != null ? this.getSentinelConfig(redisProperties, redisLockProperties, redissonProperties) : (redisProperties.getCluster() != null ? this.getClusterConfig(redisProperties, redisLockProperties, redissonProperties) : this.getSingleConfig(redisProperties, redisLockProperties, redissonProperties)))));
        if (logger.isDebugEnabled()) {
            logger.debug("Redisson config: {}", (Object)this.getConfigForDebug(config));
        }
        return Redisson.create((Config)config);
    }

    private Config getSentinelConfig(RedisProperties redisProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties) {
        RedisProperties.Sentinel sentinelProperties = redisProperties.getSentinel();
        if (sentinelProperties == null) {
            throw new NullPointerException();
        }
        String master = sentinelProperties.getMaster();
        String[] nodes = this.convertRedisNodes(redisProperties.isSsl(), sentinelProperties.getNodes());
        String sentinelUsername = sentinelProperties.getUsername();
        String sentinelPassword = sentinelProperties.getPassword();
        ConnectionInfo connectionInfo = this.getConnectionInfo(redisProperties);
        int database = redisProperties.getDatabase();
        Config config = this.createConfig(redisProperties, redisLockProperties, redissonProperties);
        SentinelServersConfig sentinelConfig = config.useSentinelServers().setMasterName(master).addSentinelAddress(nodes).setDatabase(database);
        sentinelConfig.setSentinelUsername(org.apache.commons.lang3.StringUtils.trimToNull((String)sentinelUsername));
        sentinelConfig.setSentinelPassword(org.apache.commons.lang3.StringUtils.trimToNull((String)sentinelPassword));
        sentinelConfig.setUsername(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getUsername()));
        sentinelConfig.setPassword(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getPassword()));
        this.setSharedConfig(redisProperties, redisLockProperties, redissonProperties, config, (BaseConfig<?>)sentinelConfig);
        return config;
    }

    private Config getClusterConfig(RedisProperties redisProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties) {
        RedisProperties.Cluster clusterProperties = redisProperties.getCluster();
        if (clusterProperties == null) {
            throw new NullPointerException();
        }
        String[] nodes = this.convertRedisNodes(redisProperties.isSsl(), clusterProperties.getNodes());
        ConnectionInfo connectionInfo = this.getConnectionInfo(redisProperties);
        long scanInterval = redissonProperties.getClusterScanInterval() != null ? redissonProperties.getClusterScanInterval().toMillis() : -1L;
        Config config = this.createConfig(redisProperties, redisLockProperties, redissonProperties);
        ClusterServersConfig clusterConfig = config.useClusterServers().addNodeAddress(nodes);
        clusterConfig.setUsername(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getUsername()));
        clusterConfig.setPassword(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getPassword()));
        if (scanInterval > 0L) {
            clusterConfig.setScanInterval((int)scanInterval);
        }
        this.setSharedConfig(redisProperties, redisLockProperties, redissonProperties, config, (BaseConfig<?>)clusterConfig);
        return config;
    }

    private Config getSingleConfig(RedisProperties redisProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties) {
        Config config = this.createConfig(redisProperties, redisLockProperties, redissonProperties);
        ConnectionInfo connectionInfo = this.getConnectionInfo(redisProperties);
        String address = (connectionInfo.isSsl() ? "rediss://" : "redis://") + connectionInfo.getHost() + ":" + connectionInfo.getPort();
        int database = redisProperties.getDatabase();
        SingleServerConfig singleConfig = config.useSingleServer().setAddress(address).setDatabase(database);
        singleConfig.setUsername(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getUsername()));
        singleConfig.setPassword(org.apache.commons.lang3.StringUtils.trimToNull((String)connectionInfo.getPassword()));
        this.setSharedConfig(redisProperties, redisLockProperties, redissonProperties, config, (BaseConfig<?>)singleConfig);
        return config;
    }

    private Config createConfig(RedisProperties redisProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties) {
        return new Config();
    }

    private void setSharedConfig(RedisProperties redisProperties, HussarRedisLockProperties redisLockProperties, HussarRedissonProperties redissonProperties, Config rootConfig, BaseConfig<?> dedicatedConfig) {
        if (redisProperties.getConnectTimeout() != null) {
            dedicatedConfig.setConnectTimeout((int)redisProperties.getConnectTimeout().toMillis());
        }
        if (redisProperties.getTimeout() != null) {
            dedicatedConfig.setTimeout((int)redisProperties.getTimeout().toMillis());
        }
        dedicatedConfig.setClientName(org.apache.commons.lang3.StringUtils.trimToNull((String)redisProperties.getClientName()));
        if (redissonProperties.isEnablePoolCustomization()) {
            if (dedicatedConfig instanceof SingleServerConfig) {
                SingleServerConfig singleConfig = (SingleServerConfig)dedicatedConfig;
                if (redissonProperties.getConnectionPoolMinIdle() >= 0) {
                    singleConfig.setConnectionMinimumIdleSize(redissonProperties.getConnectionPoolMinIdle());
                }
                if (redissonProperties.getConnectionPoolMaxActive() >= 0) {
                    singleConfig.setConnectionPoolSize(redissonProperties.getConnectionPoolMaxActive());
                }
                if (redissonProperties.getSubscriptionPoolMinIdle() >= 0) {
                    singleConfig.setSubscriptionConnectionMinimumIdleSize(redissonProperties.getSubscriptionPoolMinIdle());
                }
                if (redissonProperties.getSubscriptionPoolMaxActive() >= 0) {
                    singleConfig.setSubscriptionConnectionPoolSize(redissonProperties.getSubscriptionPoolMaxActive());
                }
            } else if (dedicatedConfig instanceof BaseMasterSlaveServersConfig) {
                BaseMasterSlaveServersConfig masterSlaveConfig = (BaseMasterSlaveServersConfig)dedicatedConfig;
                if (redissonProperties.getConnectionPoolMinIdle() >= 0) {
                    masterSlaveConfig.setMasterConnectionMinimumIdleSize(redissonProperties.getConnectionPoolMinIdle());
                    masterSlaveConfig.setSlaveConnectionMinimumIdleSize(redissonProperties.getConnectionPoolMinIdle());
                }
                if (redissonProperties.getConnectionPoolMaxActive() >= 0) {
                    masterSlaveConfig.setMasterConnectionPoolSize(redissonProperties.getConnectionPoolMaxActive());
                    masterSlaveConfig.setSlaveConnectionPoolSize(redissonProperties.getConnectionPoolMaxActive());
                }
                if (redissonProperties.getSubscriptionPoolMinIdle() >= 0) {
                    masterSlaveConfig.setSubscriptionConnectionMinimumIdleSize(redissonProperties.getSubscriptionPoolMinIdle());
                }
                if (redissonProperties.getSubscriptionPoolMaxActive() >= 0) {
                    masterSlaveConfig.setSubscriptionConnectionPoolSize(redissonProperties.getSubscriptionPoolMaxActive());
                }
            }
            if (redissonProperties.getThreads() >= 0) {
                rootConfig.setThreads(redissonProperties.getThreads());
            }
            if (redissonProperties.getNettyThreads() >= 0) {
                rootConfig.setNettyThreads(redissonProperties.getNettyThreads());
            }
        }
        dedicatedConfig.setNameMapper((NameMapper)new PrefixNameMapper("hussar_lock:"));
        Duration lockExpire = redisLockProperties.getLockExpire();
        if (lockExpire == null || lockExpire.compareTo(Duration.ZERO) <= 0) {
            lockExpire = HussarRedisLockConstants.DEFAULT_LOCK_EXPIRE;
        }
        rootConfig.setLockWatchdogTimeout(lockExpire.toMillis());
    }

    private String[] convertRedisNodes(boolean ssl, List<String> nodes) {
        String prefix = ssl ? "rediss://" : "redis://";
        Set hostAndPorts = StringUtils.commaDelimitedListToSet((String)StringUtils.collectionToCommaDelimitedString(nodes));
        ArrayList<String> uris = new ArrayList<String>(hostAndPorts.size());
        for (String hostAndPort : hostAndPorts) {
            RedisNode node = RedisNode.fromString((String)hostAndPort);
            String uri = prefix + node.getHost() + ":" + node.getPort();
            uris.add(uri);
        }
        return uris.toArray(new String[0]);
    }

    private ConnectionInfo getConnectionInfo(RedisProperties redisProperties) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)redisProperties.getUrl())) {
            return ConnectionInfo.parse(redisProperties.getUrl());
        }
        return new ConnectionInfo(redisProperties.isSsl(), redisProperties.getHost(), redisProperties.getPort(), redisProperties.getUsername(), redisProperties.getPassword());
    }

    private String getConfigForDebug(Config config) {
        try {
            return config.toYAML();
        }
        catch (Exception ignore) {
            return config.toString();
        }
    }

    private InputStream getConfigStream(HussarRedissonProperties redissonProperties) throws IOException {
        Resource resource = this.resourceLoader.getResource(org.apache.commons.lang3.StringUtils.trim((String)redissonProperties.getConfig()));
        return resource.getInputStream();
    }

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public static class PrefixNameMapper
    implements NameMapper {
        private final String prefix;

        public PrefixNameMapper(String prefix) {
            this.prefix = prefix;
        }

        public String map(String name) {
            return this.prefix + name;
        }

        public String unmap(String name) {
            return org.apache.commons.lang3.StringUtils.removeStart((String)name, (String)this.prefix);
        }
    }

    public static class ConnectionInfo {
        private final boolean ssl;
        private final String host;
        private final int port;
        private final String username;
        private final String password;

        public ConnectionInfo(boolean ssl, String host, int port, String username, String password) {
            this.ssl = ssl;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public static ConnectionInfo parse(String url) {
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if (!"redis".equals(scheme) && !"rediss".equals(scheme)) {
                    throw new IllegalArgumentException(url);
                }
                boolean ssl = "rediss".equals(scheme);
                String host = uri.getHost();
                int port = uri.getPort() < 0 ? uri.getPort() : 6379;
                String username = null;
                String password = null;
                if (uri.getUserInfo() != null) {
                    String candidate = uri.getUserInfo();
                    int index = candidate.indexOf(58);
                    if (index >= 0) {
                        username = candidate.substring(0, index);
                        password = candidate.substring(index + 1);
                    } else {
                        password = candidate;
                    }
                }
                return new ConnectionInfo(ssl, host, port, username, password);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(url, ex);
            }
        }

        boolean isSsl() {
            return this.ssl;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

