/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.config;

import com.jxdinfo.hussar.support.lock.config.HussarRedissonConfiguration;
import com.jxdinfo.hussar.support.lock.redis.HussarRedisLockManager;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarLockRedisType;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@Import(value={HussarRedissonConfiguration.class})
@ConditionalOnProperty(prefix="hussar.lock", value={"type"}, havingValue="redis")
@EnableConfigurationProperties(value={HussarRedisLockProperties.class})
public class HussarRedisLockConfiguration {
    @Bean
    public HussarRedisLockManager hussarLockManager(RedisProperties redisProperties, RedisTemplate<Object, Object> redisTemplate, RedissonClient redisson, HussarRedisLockProperties properties) {
        HussarLockRedisType redisType = this.getRedisType(redisProperties);
        return new HussarRedisLockManager(redisType, redisTemplate, redisson, properties);
    }

    public HussarLockRedisType getRedisType(RedisProperties redisProperties) {
        if (redisProperties.getSentinel() != null) {
            return HussarLockRedisType.SENTINEL;
        }
        if (redisProperties.getCluster() != null) {
            return HussarLockRedisType.CLUSTER;
        }
        return HussarLockRedisType.SINGLE;
    }
}

