/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis;

import com.jxdinfo.hussar.support.lock.common.HussarAbstractLockExecutionCounter;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarLockRedisType;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;

public class HussarRedisLockExecutionCounter
extends HussarAbstractLockExecutionCounter {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedisLockExecutionCounter.class);
    private static final byte[] SCRIPT_INCR_EX = "redis.call('INCR', KEYS[1]); redis.call('EXPIRE', KEYS[1], ARGV[1])".getBytes(StandardCharsets.UTF_8);
    private final HussarLockRedisType redisType;
    private final RedisTemplate<Object, Object> redisTemplate;

    public HussarRedisLockExecutionCounter(HussarLockRedisType redisType, RedisTemplate<Object, Object> redisTemplate) {
        this.redisType = redisType;
        this.redisTemplate = redisTemplate;
    }

    protected void increaseCounter(String key) {
        byte[] rawKey = this.getRawKey(key);
        byte[] rawExpiration = this.getRawKeyExpiration();
        try {
            this.redisTemplate.execute(connection -> {
                connection.eval(SCRIPT_INCR_EX, ReturnType.VALUE, 1, (byte[][])new byte[][]{rawKey, rawExpiration});
                return null;
            });
        }
        catch (Exception ex) {
            logger.warn("failed to increase lock guard counter for '{}'", (Object)key, (Object)ex);
        }
    }

    protected long getCounter(String key) {
        byte[] rawKey = this.getRawKey(key);
        Expiration expiration = this.getKeyExpiration();
        try {
            Object counter = this.redisTemplate.execute(connection -> {
                byte[] rawValue = connection.getEx(rawKey, expiration);
                return this.redisTemplate.getValueSerializer().deserialize(rawValue);
            });
            return counter instanceof Number ? ((Number)counter).longValue() : 0L;
        }
        catch (Exception ex) {
            logger.warn("failed to retrieve lock guard counter for '{}'", (Object)key, (Object)ex);
            return 0L;
        }
    }

    protected byte[] getRawKey(String key) {
        String actualKey = "hussar_lock:counter:" + key;
        return RedisSerializer.string().serialize((Object)actualKey);
    }

    private byte[] getRawKeyExpiration() {
        String seconds = String.valueOf(this.getKeyExpiration().getExpirationTimeInSeconds());
        return RedisSerializer.string().serialize((Object)seconds);
    }

    private Expiration getKeyExpiration() {
        return Expiration.seconds((long)Math.floorDiv(this.getExpire().toMillis(), 1000L));
    }
}

