/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.event.config;

import com.jxdinfo.hussar.support.event.broadcast.config.HussarBroadcastEventProperties;
import com.jxdinfo.hussar.support.event.broadcast.redis.HussarBroadcastEventRedisListener;
import com.jxdinfo.hussar.support.event.broadcast.redis.HussarBroadcastEventRedisPublisher;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@ConditionalOnProperty(prefix="hussar.event.broadcast", value={"mode"}, havingValue="redis")
@EnableConfigurationProperties(value={HussarBroadcastEventProperties.class})
public class HussarRedisBroadcastEventConfiguration {
    @Bean
    public HussarBroadcastEventRedisListener hussarBroadcastEventRedisListener(RedisTemplate<Object, Object> redisTemplate, ApplicationEventPublisher applicationEventPublisher) {
        HussarBroadcastEventRedisListener listener = new HussarBroadcastEventRedisListener();
        listener.setRedisTemplate(redisTemplate);
        listener.setApplicationEventPublisher(applicationEventPublisher);
        return listener;
    }

    @Bean
    public HussarBroadcastEventRedisPublisher hussarBroadcastEventRedisPublisher(RedisTemplate<Object, Object> redisTemplate, HussarBroadcastEventProperties hussarBroadcastEventProperties, HussarTaskExecutor hussarTaskExecutor) {
        HussarBroadcastEventRedisPublisher publisher = new HussarBroadcastEventRedisPublisher();
        publisher.setRedisTemplate(redisTemplate);
        publisher.setBroadcastProperties(hussarBroadcastEventProperties);
        publisher.setTaskExecutor(hussarTaskExecutor);
        return publisher;
    }

    @Bean
    public RedisMessageListenerContainer hussarBroadcastEventRedisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, HussarBroadcastEventRedisListener hussarBroadcastEventRedisListener) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)hussarBroadcastEventRedisListener, (Topic)new ChannelTopic("hussar_event:broadcast"));
        return container;
    }
}

