/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.event.broadcast.redis;

import com.jxdinfo.hussar.support.event.HussarAbstractEvent;
import com.jxdinfo.hussar.support.event.broadcast.HussarBroadcastEvent;
import com.jxdinfo.hussar.support.event.message.HussarRemoteEventMessage;
import com.jxdinfo.hussar.support.event.source.RemoteEventSource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;

public class HussarBroadcastEventRedisListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(HussarBroadcastEventRedisListener.class);
    private RedisTemplate<Object, Object> redisTemplate;
    private ApplicationEventPublisher applicationEventPublisher;

    public void onMessage(@NonNull Message message, byte[] pattern) {
        if (this.redisTemplate == null || this.applicationEventPublisher == null) {
            logger.trace("Missing redis template or application event publisher");
            return;
        }
        logger.trace("Received one remote event message");
        Object deserializedMessage = this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        if (!(deserializedMessage instanceof HussarRemoteEventMessage)) {
            logger.warn("Event message is corrupted: {}", deserializedMessage);
            return;
        }
        HussarRemoteEventMessage convertedMessage = (HussarRemoteEventMessage)deserializedMessage;
        if (Objects.equals(convertedMessage.getCreator(), HussarRemoteEventMessage.getCurrentMessageCreator())) {
            logger.trace("Ignore loop event message: {}", (Object)convertedMessage);
            return;
        }
        HussarAbstractEvent convertedEvent = convertedMessage.toEvent();
        if (convertedEvent == null) {
            logger.trace("Ignore inconvertible message: {}", (Object)convertedMessage);
            return;
        }
        if (!(convertedEvent instanceof HussarBroadcastEvent)) {
            logger.warn("Broadcast event is not instance of HussarBroadcastEvent<?>: {}", (Object)convertedEvent);
            return;
        }
        HussarBroadcastEvent event = (HussarBroadcastEvent)convertedEvent;
        event.setRemote(true);
        event.setSource(RemoteEventSource.INSTANCE);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

