/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.event.broadcast.redis;

import com.jxdinfo.hussar.support.event.broadcast.HussarBroadcastEvent;
import com.jxdinfo.hussar.support.event.broadcast.config.HussarBroadcastEventProperties;
import com.jxdinfo.hussar.support.event.message.HussarEventMessage;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;

public class HussarBroadcastEventRedisPublisher
implements ApplicationListener<HussarBroadcastEvent<?>> {
    private static final Logger logger = LoggerFactory.getLogger(HussarBroadcastEventRedisPublisher.class);
    private RedisTemplate<Object, Object> redisTemplate;
    private HussarBroadcastEventProperties broadcastProperties;
    private HussarTaskExecutor taskExecutor;
    private volatile RetryTemplate retryTemplate;

    public void onApplicationEvent(@NonNull HussarBroadcastEvent<?> event) {
        HussarBroadcastEventProperties properties = this.getBroadcastProperties();
        if (properties == null || !properties.isAsynchronous()) {
            this.doConvertAndBroadcast(event);
            return;
        }
        logger.trace("Asynchronous broadcast event: {}", event);
        this.taskExecutor.execute(() -> this.doConvertAndBroadcast(event));
    }

    protected void doConvertAndBroadcast(@NonNull HussarBroadcastEvent<?> event) {
        if (this.redisTemplate == null) {
            logger.trace("Missing redis template");
            return;
        }
        if (event.isRemote()) {
            logger.trace("Refused to broadcast remote event twice: {}", event);
            return;
        }
        logger.trace("Encode local event to message record: {}", event);
        HussarEventMessage message = event.toMessage();
        logger.trace("Broadcast event message record: {}", (Object)message);
        this.broadcast(message);
    }

    protected void broadcast(HussarEventMessage<?> message) {
        HussarBroadcastEventProperties properties = this.getBroadcastProperties();
        if (properties == null || !properties.isRetry()) {
            this.doBroadcast(message, false, 1, 1);
            return;
        }
        RetryTemplate retryTemplate = this.getRetryTemplate();
        retryTemplate.execute(context -> {
            this.doBroadcast(message, true, context.getRetryCount(), properties.getRetryAttempts());
            return null;
        });
    }

    protected void doBroadcast(HussarEventMessage<?> message, boolean retry, int count, int limit) throws DataAccessException {
        try {
            if (retry) {
                logger.debug("Broadcast local event message to remote (attempt {}/{}): {}", new Object[]{count + 1, limit, message});
            } else {
                logger.debug("Broadcast local event message to remote: {}", message);
            }
            this.redisTemplate.convertAndSend("hussar_event:broadcast", message);
        }
        catch (Exception ex) {
            if (retry) {
                logger.error("Failed to broadcast event message (attempt {}/{}): {}", new Object[]{count + 1, limit, message});
            } else {
                logger.error("Failed to broadcast event message: {}", message);
            }
            throw ex;
        }
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public HussarBroadcastEventProperties getBroadcastProperties() {
        return this.broadcastProperties;
    }

    public void setBroadcastProperties(HussarBroadcastEventProperties broadcastProperties) {
        this.broadcastProperties = broadcastProperties;
    }

    public HussarTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(HussarTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryTemplate getRetryTemplate() {
        if (this.retryTemplate == null) {
            HussarBroadcastEventRedisPublisher hussarBroadcastEventRedisPublisher = this;
            synchronized (hussarBroadcastEventRedisPublisher) {
                if (this.retryTemplate == null) {
                    HussarBroadcastEventProperties properties = this.getBroadcastProperties();
                    if (properties == null) {
                        properties = new HussarBroadcastEventProperties();
                    }
                    this.retryTemplate = RetryTemplate.builder().retryOn(DataAccessException.class).maxAttempts(properties.getRetryAttempts()).exponentialBackoff(properties.getRetryInitialInterval().toMillis(), properties.getRetryIntervalFactor(), properties.getRetryMaxInterval().toMillis(), properties.isRetryIntervalRandom()).build();
                }
            }
        }
        return this.retryTemplate;
    }
}

