/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloadd.framework.extension.transaction;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.mybatisplus.SpringBootMybatisPlusConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.SpringBeanRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.SpringBeanUtils;
import com.jxdinfo.hussar.support.transaction.support.aspect.HussarTransactionInterceptor;
import com.jxdinfo.hussar.support.transaction.support.attributesource.HussarAnnotationTransactionAttributeSource;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.AbstractTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.DSTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.HussarTransactionAnnotationParser;
import com.jxdinfo.hussar.support.transaction.support.attributesource.parse.SpringTransactionAnnotationParser;
import com.jxdinfo.hussar.transaction.plugin.datasource.properties.HussarTransactionProperties;
import io.seata.config.springcloud.SpringApplicationContextProvider;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.Set;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.jdbc.datasource.HussarDataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.event.TransactionalEventListenerFactory;
import org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class HussarPluginTransactionProcessor
implements PluginBeanRegistrarExtend {
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        SpringBootMybatisPlusConfig config = (SpringBootMybatisPlusConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootMybatisPlusConfig.class);
        if (config == null || !config.enableTransaction()) {
            return;
        }
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        if (mainApplicationContext.containsBean("hussarTransactionAdvisor")) {
            this.registryHussarTransaction(pluginRegistryInfo);
        }
        if (mainApplicationContext.containsBean("hussarSeataTransactionScanner")) {
            this.registrySeataTransaction(pluginRegistryInfo);
        }
    }

    private void registryHussarTransaction(PluginRegistryInfo pluginRegistryInfo) {
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        HussarTransactionProperties hussarTransactionProperties = (HussarTransactionProperties)mainApplicationContext.getBean(HussarTransactionProperties.class);
        springBeanRegister.registerSingleton("hussarTransactionProperties", (Object)hussarTransactionProperties);
        TransactionalEventListenerFactory transactionalEventListenerFactory = new TransactionalEventListenerFactory();
        springBeanRegister.registerSingleton("org.springframework.transaction.config.internalTransactionalEventListenerFactory", (Object)transactionalEventListenerFactory);
        HussarAnnotationTransactionAttributeSource hussarAnnotationTransactionAttributeSource = new HussarAnnotationTransactionAttributeSource(new AbstractTransactionAnnotationParser[]{new HussarTransactionAnnotationParser(), new SpringTransactionAnnotationParser(), new DSTransactionAnnotationParser()});
        springBeanRegister.registerSingleton("hussarAnnotationTransactionAttributeSource", (Object)hussarAnnotationTransactionAttributeSource);
        DataSource dataSource = (DataSource)mainApplicationContext.getBean(DataSource.class);
        HussarDataSourceTransactionManager transactionManager = new HussarDataSourceTransactionManager(dataSource);
        ObjectProvider transactionManagerCustomizers = mainApplicationContext.getBeanProvider(TransactionManagerCustomizers.class);
        transactionManager.setHussarTransactionProperties(hussarTransactionProperties);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        springBeanRegister.registerSingleton("hussarDataSourceTransactionManager", (Object)transactionManager);
        DefaultListableBeanFactory defaultListableBeanFactory = pluginRegistryInfo.getPluginApplicationContext().getDefaultListableBeanFactory();
        HussarTransactionInterceptor pluginInterceptor = new HussarTransactionInterceptor();
        pluginInterceptor.setTransactionAttributeSource((TransactionAttributeSource)hussarAnnotationTransactionAttributeSource);
        pluginInterceptor.setTransactionManager((TransactionManager)transactionManager);
        pluginInterceptor.setBeanFactory((BeanFactory)defaultListableBeanFactory);
        BeanFactoryTransactionAttributeSourceAdvisor advisor = (BeanFactoryTransactionAttributeSourceAdvisor)mainApplicationContext.getBean("hussarTransactionAdvisor", BeanFactoryTransactionAttributeSourceAdvisor.class);
        BeanFactoryTransactionAttributeSourceAdvisor pluginAdvisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        pluginAdvisor.setTransactionAttributeSource((TransactionAttributeSource)hussarAnnotationTransactionAttributeSource);
        pluginAdvisor.setOrder(advisor.getOrder());
        pluginAdvisor.setBeanFactory((BeanFactory)defaultListableBeanFactory);
        pluginAdvisor.setAdvice((Advice)pluginInterceptor);
        springBeanRegister.registerSingleton("hussarTransactionInterceptor", (Object)pluginInterceptor);
        springBeanRegister.registerSingleton("hussarTransactionAdvisor", (Object)pluginAdvisor);
    }

    private void registrySeataTransaction(PluginRegistryInfo pluginRegistryInfo) {
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        springBeanRegister.registerSingleton("springApplicationContextProvider", (Object)new SpringApplicationContextProvider());
        SeataProperties seataProperties = (SeataProperties)mainApplicationContext.getBean(SeataProperties.class);
        springBeanRegister.registerSingleton("seataProperties", (Object)seataProperties);
        DefaultFailureHandlerImpl failureHandler = new DefaultFailureHandlerImpl();
        springBeanRegister.registerSingleton("failureHandler", (Object)failureHandler);
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        GlobalTransactionScanner hussarSeataTransactionScanner = new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), (FailureHandler)failureHandler);
        GlobalTransactionScanner.setBeanFactory((ConfigurableListableBeanFactory)pluginApplicationContext.getDefaultListableBeanFactory());
        hussarSeataTransactionScanner.setProxyClassLoader(pluginApplicationContext.getClassLoader());
        springBeanRegister.registerSingleton("hussarSeataTransactionScanner", (Object)hussarSeataTransactionScanner);
    }

    public String key() {
        return "HussarTransactionProcessor";
    }
}

