/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.thymeleaf;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.thymeleaf.SpringBootThymeleafConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.thymeleaf.ThymeleafConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.PluginPipeProcessorExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.ClassUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.OrderPriority;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.SpringBeanUtils;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafProcessor
implements PluginPipeProcessorExtend {
    private static final String TEMPLATE_RESOLVER_BEAN = "ClassLoaderTemplateResolver";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThymeleafProcessor.class);

    public String key() {
        return "ThymeleafProcessor";
    }

    public OrderPriority order() {
        return OrderPriority.getMiddlePriority();
    }

    public void initialize() throws Exception {
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Integer order;
        String prefix;
        SpringTemplateEngine springTemplateEngine = this.getSpringTemplateEngine(pluginRegistryInfo);
        if (springTemplateEngine == null) {
            return;
        }
        ThymeleafConfig thymeleafConfig = (ThymeleafConfig)pluginRegistryInfo.getPluginBinder().bind("plugin.thymeleaf", ThymeleafConfig.class).orElse(null);
        if (thymeleafConfig == null) {
            SpringBootThymeleafConfig config = (SpringBootThymeleafConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootThymeleafConfig.class);
            if (config == null) {
                return;
            }
            thymeleafConfig = new ThymeleafConfig();
            config.config(thymeleafConfig);
        }
        if (StringUtils.isEmpty((Object)(prefix = thymeleafConfig.getPrefix()))) {
            throw new IllegalArgumentException("prefix can't be empty");
        }
        if (!prefix.endsWith("/")) {
            thymeleafConfig.setPrefix(prefix + "/");
        }
        if (StringUtils.isEmpty((Object)thymeleafConfig.getSuffix())) {
            throw new IllegalArgumentException("suffix can't be empty");
        }
        if (thymeleafConfig.getMode() == null) {
            throw new IllegalArgumentException("mode can't be null");
        }
        ClassLoader pluginClassLoader = pluginRegistryInfo.getPluginWrapper().getPluginClassLoader();
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver(pluginClassLoader);
        resolver.setPrefix(thymeleafConfig.getPrefix() + "/");
        resolver.setSuffix(thymeleafConfig.getSuffix());
        resolver.setTemplateMode(thymeleafConfig.getMode());
        resolver.setCacheable(thymeleafConfig.getCache().booleanValue());
        if (thymeleafConfig.getEncoding() != null) {
            resolver.setCharacterEncoding(thymeleafConfig.getEncoding().name());
        }
        if ((order = thymeleafConfig.getTemplateResolverOrder()) != null) {
            resolver.setOrder(order);
        }
        resolver.setCheckExistence(true);
        Set<ITemplateResolver> templateResolvers = this.getITemplateResolvers(springTemplateEngine);
        if (templateResolvers == null) {
            LOGGER.error("You can't use Thymeleaf, because not fount 'Set<ITemplateResolver>' from Bean:SpringTemplateEngine by reflect");
            return;
        }
        templateResolvers.add((ITemplateResolver)resolver);
        pluginRegistryInfo.addExtension(TEMPLATE_RESOLVER_BEAN, (Object)resolver);
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Object resolver = pluginRegistryInfo.getExtension(TEMPLATE_RESOLVER_BEAN);
        if (resolver == null) {
            return;
        }
        try {
            SpringTemplateEngine springTemplateEngine = this.getSpringTemplateEngine(pluginRegistryInfo);
            Set<ITemplateResolver> templateResolvers = this.getITemplateResolvers(springTemplateEngine);
            if (templateResolvers != null && resolver instanceof ClassLoaderTemplateResolver) {
                templateResolvers.remove(resolver);
            }
        }
        catch (Exception e) {
            LOGGER.error("unRegistry plugin '{}' templateResolver failure", (Object)pluginRegistryInfo.getPluginWrapper().getPluginId(), (Object)e);
        }
    }

    private SpringTemplateEngine getSpringTemplateEngine(PluginRegistryInfo pluginRegistryInfo) {
        GenericApplicationContext applicationContext = pluginRegistryInfo.getMainApplicationContext();
        String[] beanNamesForType = applicationContext.getBeanNamesForType(SpringTemplateEngine.class, false, false);
        if (beanNamesForType.length == 0) {
            return null;
        }
        try {
            return (SpringTemplateEngine)applicationContext.getBean(SpringTemplateEngine.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<ITemplateResolver> getITemplateResolvers(SpringTemplateEngine springTemplateEngine) throws IllegalAccessException {
        if (springTemplateEngine == null) {
            return null;
        }
        return (Set)ClassUtils.getReflectionField((Object)springTemplateEngine, (String)"templateResolvers");
    }
}

