/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.support;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.support.service.dto.SharePluginInfo;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionExtensionFieldConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionExtensionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionFieldConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionMethodConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.PluginExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionColumnInfoServiceVo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionExtensionTableInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionExtensionTableServiceDto;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableColumnsInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableVo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.extract.ExtractFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMybatisExpansionColumnInfoService
implements ExpansionColumnInfoService {
    private static final Logger log = LoggerFactory.getLogger(ExtensionMybatisExpansionColumnInfoService.class);
    private PluginRegistryInfo pluginRegistryInfo;
    private final ExtractFactory extractFactory = ExtractFactory.getInstant();
    private HussarExpansionProperties hussarExpansionProperties;

    public ExtensionMybatisExpansionColumnInfoService(PluginRegistryInfo pluginRegistryInfo) {
        this.pluginRegistryInfo = pluginRegistryInfo;
    }

    public ExtensionMybatisExpansionColumnInfoService(PluginRegistryInfo pluginRegistryInfo, HussarExpansionProperties hussarExpansionProperties) {
        this.pluginRegistryInfo = pluginRegistryInfo;
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public List<ExpansionTableColumnsInfo> getExpansionColumnInfo(ExpansionColumnInfoServiceVo expansionColumnInfoServiceVo) {
        if (HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo) || HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo.getTableInfos()) || HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo.getModelId())) {
            return null;
        }
        String modelId = expansionColumnInfoServiceVo.getModelId();
        List tableInfos = expansionColumnInfoServiceVo.getTableInfos();
        PluginExpansionColumnInfoService pluginExpansionColumnInfoService = this.getPluginExpansionColumnInfoService();
        if (HussarUtils.isEmpty((Object)pluginExpansionColumnInfoService)) {
            return null;
        }
        List expansionTableConfigInfos = pluginExpansionColumnInfoService.getExpansionColumnInfo(modelId);
        if (HussarUtils.isEmpty((Object)expansionTableConfigInfos)) {
            return null;
        }
        ArrayList<ExpansionTableColumnsInfo> returnExpansionTableColumnsInfoList = new ArrayList<ExpansionTableColumnsInfo>();
        for (ExpansionTableVo tableInfo : tableInfos) {
            List expansionTableColumnsInfoList = this.getExpansionTableInfoByTableName(tableInfo, expansionTableConfigInfos);
            if (HussarUtils.isEmpty((Object)expansionTableColumnsInfoList)) continue;
            returnExpansionTableColumnsInfoList.addAll(expansionTableColumnsInfoList);
        }
        return returnExpansionTableColumnsInfoList;
    }

    public ExpansionTableColumnsInfo getSuperQueryColumnService(String modelId, String propertyName, boolean enableAlias) {
        if (HussarUtils.isEmpty((Object)propertyName) || HussarUtils.isEmpty((Object)modelId)) {
            return null;
        }
        PluginExpansionColumnInfoService pluginExpansionColumnInfoService = this.getPluginExpansionColumnInfoService();
        if (HussarUtils.isEmpty((Object)pluginExpansionColumnInfoService)) {
            return null;
        }
        List expansionTableConfigInfos = pluginExpansionColumnInfoService.getExpansionColumnInfo(modelId);
        List extensionTableConfigInfos = pluginExpansionColumnInfoService.getExpansionExtensionTableConfigInfoService(modelId);
        if (HussarUtils.isEmpty((Object)expansionTableConfigInfos) && HussarUtils.isEmpty((Object)extensionTableConfigInfos)) {
            return null;
        }
        ArrayList allExpansionTableInfos = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isNotEmpty((Object)expansionTableConfigInfos)) {
            allExpansionTableInfos.addAll(expansionTableConfigInfos);
        }
        if (HussarUtils.isNotEmpty((Object)extensionTableConfigInfos)) {
            allExpansionTableInfos.addAll(this.convertToExpansionTableConfigList(extensionTableConfigInfos));
        }
        ExpansionTableColumnsInfo expansionTableColumnsInfo = this.doGetSuperQueryExpansionColums(allExpansionTableInfos, propertyName, enableAlias);
        return expansionTableColumnsInfo;
    }

    private List<ExpansionTableConfigInfo> convertToExpansionTableConfigList(List<ExpansionExtensionTableConfigInfo> extensionTableConfigInfos) {
        ArrayList expansionTableConfigInfos = Lists.newArrayListWithCapacity((int)extensionTableConfigInfos.size());
        for (ExpansionExtensionTableConfigInfo extensionTableConfigInfo : extensionTableConfigInfos) {
            if (HussarUtils.isEmpty((Object)extensionTableConfigInfo.getFields())) continue;
            ExpansionTableConfigInfo expansionTableConfigInfo = new ExpansionTableConfigInfo();
            expansionTableConfigInfo.setModelName(extensionTableConfigInfo.getModelName());
            expansionTableConfigInfo.setTableName(extensionTableConfigInfo.getTableName());
            expansionTableConfigInfo.setAlias(extensionTableConfigInfo.getAlias());
            expansionTableConfigInfo.setType(extensionTableConfigInfo.getType());
            expansionTableConfigInfo.setFields(this.convertToExpansionFieldConfigInfo(extensionTableConfigInfo.getFields()));
            expansionTableConfigInfos.add(expansionTableConfigInfo);
        }
        return expansionTableConfigInfos;
    }

    private List<ExpansionFieldConfigInfo> convertToExpansionFieldConfigInfo(List<ExpansionExtensionFieldConfigInfo> fields) {
        ArrayList expansionFieldConfigInfos = Lists.newArrayListWithCapacity((int)fields.size());
        for (ExpansionExtensionFieldConfigInfo fieldConfigInfo : fields) {
            ExpansionFieldConfigInfo expansionFieldConfigInfo = new ExpansionFieldConfigInfo();
            expansionFieldConfigInfo.setTableName(fieldConfigInfo.getTableName());
            expansionFieldConfigInfo.setColumnName(fieldConfigInfo.getColumnName());
            expansionFieldConfigInfo.setColumnAlias(fieldConfigInfo.getColumnAlias());
            expansionFieldConfigInfo.setColumnType(fieldConfigInfo.getColumnType());
            expansionFieldConfigInfo.setEscape(fieldConfigInfo.getEscape());
            expansionFieldConfigInfo.setExcludeInfos(fieldConfigInfo.getExcludeInfos());
            expansionFieldConfigInfo.setOptType(fieldConfigInfo.getOptType());
            expansionFieldConfigInfo.setPositionType(fieldConfigInfo.getPositionType());
            expansionFieldConfigInfo.setPropertyName(fieldConfigInfo.getPropertyName());
            expansionFieldConfigInfo.setPropertyType(fieldConfigInfo.getPropertyType());
            expansionFieldConfigInfos.add(expansionFieldConfigInfo);
        }
        return expansionFieldConfigInfos;
    }

    public List<ExpansionMethodConfigInfo> getExpansionMethodConfigInfoService(String modelId) {
        if (HussarUtils.isEmpty((Object)modelId)) {
            return null;
        }
        PluginExpansionColumnInfoService pluginExpansionColumnInfoService = this.getPluginExpansionColumnInfoService();
        if (HussarUtils.isEmpty((Object)pluginExpansionColumnInfoService)) {
            return null;
        }
        List expansionMethodConfigInfoList = pluginExpansionColumnInfoService.getExpansionMethodConfigInfoService(modelId);
        if (HussarUtils.isEmpty((Object)expansionMethodConfigInfoList)) {
            return null;
        }
        return expansionMethodConfigInfoList;
    }

    public List<ExpansionExtensionTableInfo> getExpansionExtensionTableInfo(ExpansionExtensionTableServiceDto expansionExtensionTableServiceDto) {
        if (HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto) || HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto.getTableInfos()) || HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto.getModelId())) {
            return null;
        }
        PluginExpansionColumnInfoService pluginExpansionColumnInfoService = this.getPluginExpansionColumnInfoService();
        if (HussarUtils.isEmpty((Object)pluginExpansionColumnInfoService)) {
            return null;
        }
        String modelId = expansionExtensionTableServiceDto.getModelId();
        List expansionExtensionTableConfigInfos = pluginExpansionColumnInfoService.getExpansionExtensionTableConfigInfoService(modelId);
        if (HussarUtils.isEmpty((Object)expansionExtensionTableConfigInfos)) {
            return null;
        }
        List tableInfos = expansionExtensionTableServiceDto.getTableInfos();
        ArrayList<ExpansionExtensionTableInfo> returnExpansionTableColumnsInfoList = new ArrayList<ExpansionExtensionTableInfo>();
        for (ExpansionTableVo tableInfo : tableInfos) {
            List expansionExtensionTableInfos = this.doGetExpansionExtensionTableConfigInfoService(tableInfo, expansionExtensionTableConfigInfos);
            if (HussarUtils.isEmpty((Object)expansionExtensionTableInfos)) continue;
            returnExpansionTableColumnsInfoList.addAll(expansionExtensionTableInfos);
        }
        return returnExpansionTableColumnsInfoList;
    }

    private String getExpansionPluginId() {
        String pluginId = this.pluginRegistryInfo.getPluginWrapper().getPluginId();
        String expansionPluginId = null;
        if (HussarUtils.isNotEmpty((Object)this.hussarExpansionProperties) && this.hussarExpansionProperties.isShared()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            log.info("config share plugin columnInfo get pluginid start......");
            if (HussarUtils.isEmpty((Object)tenant) || HussarUtils.isEmpty((Object)tenant.getTenantCode())) {
                log.error("\u83b7\u53d6columnInfo,\u672a\u627e\u5230\u5f53\u524d\u7684\u79df\u6237code:{},\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f", (Object)tenant.getTenantCode());
                return null;
            }
            Map appV1CodeMap = HussarFixedCacheUtil.getHash((String)"share-plugins", (String)("tenant-plugins:" + tenant.getTenantCode()));
            if (HussarUtils.isEmpty((Object)appV1CodeMap)) {
                log.error("\u83b7\u53d6columnInfo,\u672a\u627e\u5230\u5f53\u524d\u7684\u79df\u6237code:{},\u4e0b\u7684\u914d\u7f6e\u63d2\u4ef6\u7684\u4fe1\u606f,\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f", (Object)tenant.getTenantCode());
                expansionPluginId = tenant.getTenantCode() + "-" + pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
            } else {
                expansionPluginId = this.getExpansionPluginId(pluginId, tenant.getTenantCode(), appV1CodeMap);
            }
            log.info("config share plugin getpluginId={}", (Object)pluginId);
            return expansionPluginId;
        }
        log.info("not config share plugin columnInfo get pluginid start......");
        expansionPluginId = pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
        log.info("not config share plugin columnInfo getpluginId={}", (Object)pluginId);
        return expansionPluginId;
    }

    private String getExpansionPluginId(String pluginId, String tenantCode, Map<Object, Object> appV1CodeMap) {
        String expansionPluginId;
        try {
            Optional<SharePluginInfo> optional = appV1CodeMap.values().stream().filter(o -> {
                SharePluginInfo sharePluginInfo = (SharePluginInfo)o;
                return pluginId.equalsIgnoreCase(sharePluginInfo.getSharePluginId() + "-" + sharePluginInfo.getAppVersion());
            }).map(o -> (SharePluginInfo)o).findFirst();
            expansionPluginId = optional.isPresent() && HussarUtils.isNotEmpty((Object)optional.get().getExpansionPluginId()) ? optional.get().getExpansionPluginId() : tenantCode + "-" + pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
            log.info("config share plugin sharePluginId:{}", (Object)(optional.isPresent() ? optional.get().getSharePluginId() : ""));
        }
        catch (Exception ex) {
            log.error("\u4ece\u7f13\u5b58map\u4e2d\u83b7\u53d6pluginId\u5f02\u5e38:", (Throwable)ex);
            expansionPluginId = null;
        }
        return expansionPluginId;
    }

    private PluginExpansionColumnInfoService getPluginExpansionColumnInfoService() {
        String pluginId = this.getExpansionPluginId();
        if (HussarUtils.isEmpty((Object)pluginId)) {
            return null;
        }
        List extractByInterClass = this.extractFactory.getExtractByInterClass(pluginId, PluginExpansionColumnInfoService.class);
        if (HussarUtils.isEmpty((Object)extractByInterClass)) {
            return null;
        }
        PluginExpansionColumnInfoService pluginExpansionColumnInfoService = (PluginExpansionColumnInfoService)extractByInterClass.get(0);
        return pluginExpansionColumnInfoService;
    }
}

