/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.AbstractExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.MybatisProcessor;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.group.MybatisConfigGroup;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.group.PluginEntityAliasesGroup;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.group.PluginMapperGroup;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.mybatisplus.MybatisPlusProcessor;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.tkmyabtis.TkMybatisProcessor;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.classs.PluginClassGroupExtend;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class SpringBootMybatisExtension
extends AbstractExtension {
    private static final String KEY = "SpringBootMybatisPlusExtension";
    private final Type type;

    public SpringBootMybatisExtension(Type type) {
        this.type = type == null ? Type.MYBATIS : type;
    }

    public String key() {
        return KEY;
    }

    public void initialize(ApplicationContext mainApplicationContext) throws Exception {
    }

    public List<PluginClassGroupExtend> getPluginClassGroup(ApplicationContext mainApplicationContext) {
        ArrayList<PluginClassGroupExtend> pluginClassGroups = new ArrayList<PluginClassGroupExtend>();
        pluginClassGroups.add(new MybatisConfigGroup());
        pluginClassGroups.add(new PluginEntityAliasesGroup());
        pluginClassGroups.add(new PluginMapperGroup());
        return pluginClassGroups;
    }

    public List<PluginBeanRegistrarExtend> getPluginBeanRegistrar(ApplicationContext mainApplicationContext) {
        ArrayList<PluginBeanRegistrarExtend> pluginBeanRegistrarExtends = new ArrayList<PluginBeanRegistrarExtend>(3);
        if (this.type == Type.MYBATIS_PLUS) {
            pluginBeanRegistrarExtends.add(new MybatisPlusProcessor());
        } else if (this.type == Type.TK_MYBATIS) {
            pluginBeanRegistrarExtends.add(new TkMybatisProcessor());
        } else {
            pluginBeanRegistrarExtends.add(new MybatisProcessor());
        }
        return pluginBeanRegistrarExtends;
    }

    public static enum Type {
        MYBATIS,
        MYBATIS_PLUS,
        TK_MYBATIS;

    }
}

