/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.mybatisplus;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationInterceptor;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.processor.DsSpelExpressionProcessor;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDatasourceAopProperties;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.aspect.AuditLogAnnotationAdvisor;
import com.jxdinfo.hussar.support.audit.aspect.AuditLogAnnotationInterceptor;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.datasource.support.DynamicDsTokenProcessor;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.CommonRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.MapperHandler;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.PluginFollowCoreConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.PluginResourceFinder;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.mybatisplus.SpringBootMybatisPlusConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.SpringBeanRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.SpringBeanUtils;
import com.jxdinfo.hussar.support.mp.transaction.HussarMpTransactionFactory;
import com.jxdinfo.hussar.support.mp.translator.HussarMybatisExceptionTranslator;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class MybatisPlusProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisPlusProcessor.class);

    public String key() {
        return "MybatisPlusProcessor";
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        SpringBootMybatisPlusConfig config = (SpringBootMybatisPlusConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootMybatisPlusConfig.class);
        if (config == null) {
            return;
        }
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        if (config.enableOneselfConfig()) {
            config.oneselfConfig(factory);
        } else {
            this.resetMainMybatisConfig(pluginRegistryInfo, factory, config);
        }
        this.registerMybatisPlusSupport(pluginRegistryInfo, factory, config);
        this.registerAuditSupport(pluginRegistryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMybatisPlusSupport(PluginRegistryInfo pluginRegistryInfo, MybatisSqlSessionFactoryBean factory, SpringBootMybatisPlusConfig config) throws Exception {
        Resource[] xmlResource;
        PluginResourceFinder pluginResourceFinder = new PluginResourceFinder(pluginRegistryInfo);
        Class[] aliasesClasses = pluginResourceFinder.getAliasesClasses(config.entityPackage());
        if (aliasesClasses != null && aliasesClasses.length > 0) {
            factory.setTypeAliases(aliasesClasses);
        }
        if ((xmlResource = pluginResourceFinder.getXmlResource(config.xmlLocationsMatch())) != null && xmlResource.length > 0) {
            factory.setMapperLocations(xmlResource);
        }
        ClassLoader defaultClassLoader = Resources.getDefaultClassLoader();
        try {
            Resources.setDefaultClassLoader((ClassLoader)pluginRegistryInfo.getPluginClassLoader());
            SqlSessionFactory sqlSessionFactory = factory.getObject();
            if (sqlSessionFactory == null) {
                throw new Exception("Get mybatis-plus sqlSessionFactory is null");
            }
            HussarMybatisExceptionTranslator persistenceExceptionTranslator = new HussarMybatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
            SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType(), (PersistenceExceptionTranslator)persistenceExceptionTranslator);
            MapperHandler mapperHandler = new MapperHandler();
            mapperHandler.processMapper(pluginRegistryInfo, (holder, mapperClass) -> mapperHandler.commonProcessMapper(holder, mapperClass, sqlSessionFactory, sqlSessionTemplate));
            CommonRegister.commonRegister(pluginRegistryInfo, sqlSessionFactory, sqlSessionTemplate);
        }
        finally {
            Resources.setDefaultClassLoader((ClassLoader)defaultClassLoader);
        }
        this.registerDynamicDatasourceSupport(pluginRegistryInfo);
    }

    private void registerDynamicDatasourceSupport(PluginRegistryInfo pluginRegistryInfo) {
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        DefaultListableBeanFactory pluginListableBeanFactory = pluginRegistryInfo.getPluginApplicationContext().getDefaultListableBeanFactory();
        HussarDynamicProperties hussarDynamicProperties = (HussarDynamicProperties)mainApplicationContext.getBean(HussarDynamicProperties.class);
        HeaderDatasourceKey headerDatasourceKey = (HeaderDatasourceKey)mainApplicationContext.getBean(HeaderDatasourceKey.class);
        DynamicDsTokenProcessor dsTokenProcessor = new DynamicDsTokenProcessor(hussarDynamicProperties, headerDatasourceKey);
        DsSpelExpressionProcessor spelExpressionProcessor = new DsSpelExpressionProcessor();
        dsTokenProcessor.setNextProcessor((DsProcessor)spelExpressionProcessor);
        CommonRegister.commonRegister(pluginRegistryInfo, "dsProcessor", dsTokenProcessor);
        DynamicDataSourceProperties dynamicDataSourceProperties = (DynamicDataSourceProperties)mainApplicationContext.getBean(DynamicDataSourceProperties.class);
        DynamicDatasourceAopProperties aop = dynamicDataSourceProperties.getAop();
        DynamicDataSourceAnnotationInterceptor interceptor = new DynamicDataSourceAnnotationInterceptor(aop.getAllowedPublicOnly(), (DsProcessor)dsTokenProcessor);
        DynamicDataSourceAnnotationAdvisor advisor = new DynamicDataSourceAnnotationAdvisor((MethodInterceptor)interceptor, DS.class);
        advisor.setOrder(aop.getOrder().intValue());
        advisor.setBeanFactory((BeanFactory)pluginListableBeanFactory);
        CommonRegister.commonRegister(pluginRegistryInfo, "dynamicDatasourceAnnotationAdvisor", advisor);
    }

    private void registerAuditSupport(PluginRegistryInfo pluginRegistryInfo) {
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        AuditLogProperties auditLogProperties = null;
        try {
            auditLogProperties = (AuditLogProperties)mainApplicationContext.getBean(AuditLogProperties.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (HussarUtils.isEmpty(auditLogProperties) || !auditLogProperties.getEnable()) {
            return;
        }
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        DefaultListableBeanFactory defaultListableBeanFactory = pluginRegistryInfo.getPluginApplicationContext().getDefaultListableBeanFactory();
        GetLoginUserService loginUserService = (GetLoginUserService)mainApplicationContext.getBean(GetLoginUserService.class);
        AuditLogAnnotationInterceptor auditLogAnnotationInterceptor = new AuditLogAnnotationInterceptor(auditLogProperties, (ApplicationEventPublisher)mainApplicationContext, loginUserService);
        AuditLogAnnotationAdvisor auditLogAnnotationAdvisor = new AuditLogAnnotationAdvisor((Advice)auditLogAnnotationInterceptor);
        auditLogAnnotationAdvisor.setBeanFactory((BeanFactory)defaultListableBeanFactory);
        springBeanRegister.registerSingleton("auditLogAnnotationAdvisor", (Object)auditLogAnnotationAdvisor);
        springBeanRegister.registerSingleton("auditLogAnnotationInterceptor", (Object)auditLogAnnotationInterceptor);
    }

    private void resetMainMybatisConfig(PluginRegistryInfo pluginRegistryInfo, MybatisSqlSessionFactoryBean factory, SpringBootMybatisPlusConfig config) {
        GenericApplicationContext mainApplicationContext;
        LanguageDriver[] languageDriver;
        DatabaseIdProvider databaseIdProvider;
        PluginFollowCoreConfig followCoreConfig = new PluginFollowCoreConfig((ApplicationContext)pluginRegistryInfo.getMainApplicationContext());
        MybatisConfiguration mybatisPlusConfiguration = followCoreConfig.getMybatisPlusConfiguration();
        factory.setDataSource(followCoreConfig.getDataSource());
        factory.setConfiguration(mybatisPlusConfiguration);
        Interceptor[] interceptor = followCoreConfig.getInterceptor(pluginRegistryInfo);
        if (interceptor != null && interceptor.length > 0) {
            factory.setPlugins(interceptor);
        }
        if ((databaseIdProvider = followCoreConfig.getDatabaseIdProvider()) != null) {
            factory.setDatabaseIdProvider(databaseIdProvider);
        }
        if ((languageDriver = followCoreConfig.getLanguageDriver()) != null) {
            factory.setScriptingLanguageDrivers(languageDriver);
        }
        if ((mainApplicationContext = pluginRegistryInfo.getMainApplicationContext()).containsBean("hussarTransactionAdvisor") && config.enableTransaction()) {
            HussarMpTransactionFactory hussarMpTransactionFactory = new HussarMpTransactionFactory();
            factory.setTransactionFactory((TransactionFactory)hussarMpTransactionFactory);
        }
        GlobalConfig globalConfig = this.mybatisPlusFollowCoreConfig(factory, pluginRegistryInfo.getMainApplicationContext());
        config.reSetMainConfig(mybatisPlusConfiguration, globalConfig);
    }

    private GlobalConfig mybatisPlusFollowCoreConfig(MybatisSqlSessionFactoryBean factory, GenericApplicationContext mainApplicationContext) {
        MybatisPlusProperties plusProperties = (MybatisPlusProperties)mainApplicationContext.getBean(MybatisPlusProperties.class);
        GlobalConfig currentGlobalConfig = new GlobalConfig();
        currentGlobalConfig.setBanner(false);
        GlobalConfig globalConfig = plusProperties.getGlobalConfig();
        if (globalConfig != null) {
            currentGlobalConfig.setDbConfig(globalConfig.getDbConfig());
            currentGlobalConfig.setIdentifierGenerator(globalConfig.getIdentifierGenerator());
            currentGlobalConfig.setMetaObjectHandler(globalConfig.getMetaObjectHandler());
            currentGlobalConfig.setSqlInjector(globalConfig.getSqlInjector());
        }
        factory.setGlobalConfig(currentGlobalConfig);
        return currentGlobalConfig;
    }
}

