/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.interceptor.AuditLogMybatisInterceptor;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.SpringBootMybatisExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.LanguageDriverRegistry;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class PluginFollowCoreConfig {
    private final ApplicationContext mainApplicationContext;

    public PluginFollowCoreConfig(ApplicationContext mainApplicationContext) {
        this.mainApplicationContext = mainApplicationContext;
    }

    public DataSource getDataSource() {
        return (DataSource)this.mainApplicationContext.getBean(DataSource.class);
    }

    public Configuration getConfiguration(SpringBootMybatisExtension.Type type) {
        Configuration configuration = new Configuration();
        if (type == SpringBootMybatisExtension.Type.MYBATIS) {
            try {
                Map customizerMap = this.mainApplicationContext.getBeansOfType(org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer.class);
                if (!customizerMap.isEmpty()) {
                    for (org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer customizer : customizerMap.values()) {
                        customizer.customize(configuration);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return configuration;
    }

    public MybatisConfiguration getMybatisPlusConfiguration() {
        MybatisConfiguration configuration = new MybatisConfiguration();
        SqlSessionFactory mainSqlSessionFactory = this.getSqlSessionFactory();
        Configuration mainConfiguration = mainSqlSessionFactory.getConfiguration();
        configuration.setLogImpl(mainConfiguration.getLogImpl());
        try {
            Map customizerMap = this.mainApplicationContext.getBeansOfType(ConfigurationCustomizer.class);
            if (!customizerMap.isEmpty()) {
                for (ConfigurationCustomizer customizer : customizerMap.values()) {
                    customizer.customize(configuration);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configuration;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
        return sqlSessionFactory;
    }

    public Interceptor[] getInterceptor(PluginRegistryInfo pluginRegistryInfo) {
        Map beanInterceptorMap;
        HashMap interceptorMap = new HashMap();
        try {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
            List interceptors = sqlSessionFactory.getConfiguration().getInterceptors();
            if (interceptors != null) {
                for (Interceptor interceptor : interceptors) {
                    if (interceptor == null) continue;
                    interceptorMap.put(interceptor.getClass(), interceptor);
                }
            }
        }
        catch (Exception sqlSessionFactory) {
            // empty catch block
        }
        if (!(beanInterceptorMap = this.mainApplicationContext.getBeansOfType(Interceptor.class)).isEmpty()) {
            beanInterceptorMap.forEach((k, v) -> interceptorMap.put(v.getClass(), v));
        }
        if (interceptorMap.isEmpty()) {
            return null;
        }
        Optional<InterceptorObject> auditLogMybatisInterceptorOptional = interceptorMap.entrySet().stream().filter(e -> e.getValue() instanceof AuditLogMybatisInterceptor).map(e -> {
            InterceptorObject interceptorObject = new InterceptorObject();
            interceptorObject.setInterceptor((Interceptor)e.getValue());
            interceptorObject.setClz((Class)e.getKey());
            return interceptorObject;
        }).findFirst();
        if (auditLogMybatisInterceptorOptional.isPresent()) {
            InterceptorObject interceptorObject = auditLogMybatisInterceptorOptional.get();
            AuditLogMybatisInterceptor auditLogMybatisInterceptor = (AuditLogMybatisInterceptor)interceptorObject.getInterceptor();
            AuditLogMybatisInterceptor newAuditLogInterceptor = new AuditLogMybatisInterceptor(auditLogMybatisInterceptor.getListener(), auditLogMybatisInterceptor.getMetaSupportService(), pluginRegistryInfo.getPluginClassLoader());
            newAuditLogInterceptor.setAuditLogProperties(auditLogMybatisInterceptor.getAuditLogProperties());
            newAuditLogInterceptor.setClassLoader(pluginRegistryInfo.getPluginClassLoader());
            interceptorMap.put(newAuditLogInterceptor.getClass(), newAuditLogInterceptor);
        }
        return interceptorMap.values().toArray(new Interceptor[0]);
    }

    public Interceptor[] getInterceptor() {
        Map beanInterceptorMap;
        HashMap interceptorMap = new HashMap();
        try {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
            List interceptors = sqlSessionFactory.getConfiguration().getInterceptors();
            if (interceptors != null) {
                for (Interceptor interceptor : interceptors) {
                    if (interceptor == null) continue;
                    interceptorMap.put(interceptor.getClass(), interceptor);
                }
            }
        }
        catch (Exception sqlSessionFactory) {
            // empty catch block
        }
        if (!(beanInterceptorMap = this.mainApplicationContext.getBeansOfType(Interceptor.class)).isEmpty()) {
            beanInterceptorMap.forEach((k, v) -> interceptorMap.put(v.getClass(), (Interceptor)v));
        }
        if (interceptorMap.isEmpty()) {
            return null;
        }
        return interceptorMap.values().toArray(new Interceptor[0]);
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        String[] beanNamesForType = this.mainApplicationContext.getBeanNamesForType(DatabaseIdProvider.class, false, false);
        if (beanNamesForType.length > 0) {
            return (DatabaseIdProvider)this.mainApplicationContext.getBean(DatabaseIdProvider.class);
        }
        return null;
    }

    public LanguageDriver[] getLanguageDriver() {
        HashMap languageDriverMap = new HashMap();
        try {
            SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.mainApplicationContext.getBean(SqlSessionFactory.class);
            LanguageDriverRegistry languageRegistry = sqlSessionFactory.getConfiguration().getLanguageRegistry();
            Field proxyTypesField = ReflectionUtils.findField(languageRegistry.getClass(), (String)"LANGUAGE_DRIVER_MAP");
            Map driverMap = null;
            if (proxyTypesField != null) {
                if (!proxyTypesField.isAccessible()) {
                    proxyTypesField.setAccessible(true);
                }
                driverMap = (Map)proxyTypesField.get(languageRegistry);
            }
            if (driverMap != null) {
                languageDriverMap.putAll(driverMap);
            }
        }
        catch (Exception sqlSessionFactory) {
            // empty catch block
        }
        Map beansLanguageDriver = this.mainApplicationContext.getBeansOfType(LanguageDriver.class);
        if (!beansLanguageDriver.isEmpty()) {
            beansLanguageDriver.forEach((k, v) -> languageDriverMap.put(v.getClass(), v));
        }
        if (languageDriverMap.isEmpty()) {
            return null;
        }
        return languageDriverMap.values().toArray(new LanguageDriver[0]);
    }

    public class InterceptorObject {
        private Class clz;
        private Interceptor interceptor;

        public Class getClz() {
            return this.clz;
        }

        public void setClz(Class clz) {
            this.clz = clz;
        }

        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        public void setInterceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
        }
    }
}

