/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloadd.framework.extension.mainservice.processor;

import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.SpringBeanRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.IntegrationConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;

public class MainServiceProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainServiceProcessor.class);

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        this.registerMainService(pluginRegistryInfo);
    }

    private void registerMainService(PluginRegistryInfo pluginRegistryInfo) {
        IntegrationConfiguration configuration = pluginRegistryInfo.getConfiguration();
        List mainServices = configuration.mainServiceToPlugins();
        Set pluginMainServices = (Set)pluginRegistryInfo.getPluginBinder().bind("plugin.plugin-main-service", Bindable.setOf(String.class)).orElseGet(() -> null);
        ArrayList totalServices = new ArrayList();
        if (mainServices != null && mainServices.size() > 0) {
            totalServices.addAll(mainServices);
        }
        if (pluginMainServices != null && pluginMainServices.size() > 0) {
            totalServices.addAll(pluginMainServices);
        }
        if (totalServices.size() <= 0) {
            return;
        }
        ClassLoader classLoader = pluginRegistryInfo.getMainApplicationContext().getClassLoader();
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        for (String clz : totalServices) {
            Object bean;
            Class<?> aClass;
            if (clz == null || (aClass = this.loadValidateClass(clz, classLoader)) == null || (bean = this.getBeanFromApplicationContext(aClass, mainApplicationContext)) == null) continue;
            String beanName = this.generalBeanName(aClass);
            springBeanRegister.registerSingleton(beanName, bean);
        }
    }

    public String key() {
        return "MainServiceProcessor";
    }

    private Object getBeanFromApplicationContext(Class clz, GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = applicationContext.getBean(clz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bean;
    }

    private Class<?> loadValidateClass(String className, ClassLoader classLoader) {
        Class<?> clz = null;
        try {
            clz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("\u4e3b\u7a0b\u5e8f\u914d\u7f6e\u7684class\u5728classloader[" + classLoader.getClass().getName() + "]\u672a\u627e\u5230classname=[" + className + "]");
        }
        return clz;
    }

    private String generalBeanName(Class clz) {
        String beanClassName = clz.getName();
        String shortClassName = ClassUtils.getShortName((String)beanClassName);
        String packageName = ClassUtils.getPackageName((String)beanClassName);
        String stringBuilder = packageName + "." + shortClassName;
        return stringBuilder;
    }
}

